/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mov;

import cn.allbs.metadata.imaging.quicktime.QuickTimeHandler;
import cn.allbs.metadata.lang.DateUtil;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mov.QuickTimeContext;
import cn.allbs.metadata.metadata.mov.QuickTimeDirectory;
import cn.allbs.metadata.metadata.mov.atoms.Atom;
import java.io.IOException;

public abstract class QuickTimeMediaHandler<T extends QuickTimeDirectory>
extends QuickTimeHandler<T> {
    public QuickTimeMediaHandler(Metadata metadata, QuickTimeContext context) {
        super(metadata);
        if (context.creationTime != null && context.modificationTime != null) {
            this.directory.setDate(20481, DateUtil.get1Jan1904EpochDate(context.creationTime));
            this.directory.setDate(20482, DateUtil.get1Jan1904EpochDate(context.modificationTime));
        }
    }

    @Override
    public boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals(this.getMediaInformation()) || atom.type.equals("stsd") || atom.type.equals("stts");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Atom atom) {
        return atom.type.equals("stbl") || atom.type.equals("minf") || atom.type.equals("gmhd") || atom.type.equals("tmcd");
    }

    @Override
    public QuickTimeMediaHandler<?> processAtom(@NotNull Atom atom, @Nullable byte[] payload, QuickTimeContext context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals(this.getMediaInformation())) {
                this.processMediaInformation(reader, atom);
            } else if (atom.type.equals("stsd")) {
                this.processSampleDescription(reader, atom);
            } else if (atom.type.equals("stts")) {
                this.processTimeToSample(reader, atom, context);
            }
        }
        return this;
    }

    protected abstract String getMediaInformation();

    protected abstract void processSampleDescription(@NotNull SequentialReader var1, @NotNull Atom var2) throws IOException;

    protected abstract void processMediaInformation(@NotNull SequentialReader var1, @NotNull Atom var2) throws IOException;

    protected abstract void processTimeToSample(@NotNull SequentialReader var1, @NotNull Atom var2, QuickTimeContext var3) throws IOException;
}

