/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mov;

import cn.allbs.metadata.imaging.quicktime.QuickTimeHandler;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mov.QuickTimeContext;
import cn.allbs.metadata.metadata.mov.QuickTimeDirectory;
import cn.allbs.metadata.metadata.mov.atoms.Atom;
import cn.allbs.metadata.metadata.mov.metadata.QuickTimeMetadataDirectory;
import java.io.IOException;

public abstract class QuickTimeMetadataHandler
extends QuickTimeHandler<QuickTimeDirectory> {
    public QuickTimeMetadataHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    @NotNull
    protected QuickTimeDirectory getDirectory() {
        return new QuickTimeMetadataDirectory();
    }

    @Override
    protected boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals("hdlr") || atom.type.equals("keys") || atom.type.equals("data");
    }

    @Override
    protected boolean shouldAcceptContainer(@NotNull Atom atom) {
        return atom.type.equals("ilst");
    }

    @Override
    protected QuickTimeHandler<?> processAtom(@NotNull Atom atom, @Nullable byte[] payload, QuickTimeContext context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals("keys")) {
                this.processKeys(reader);
            } else if (atom.type.equals("data")) {
                this.processData(payload, reader);
            }
        }
        return this;
    }

    protected abstract void processKeys(@NotNull SequentialByteArrayReader var1) throws IOException;

    protected abstract void processData(@NotNull byte[] var1, @NotNull SequentialByteArrayReader var2) throws IOException;
}

