/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mp4;

import cn.allbs.metadata.imaging.mp4.Mp4Handler;
import cn.allbs.metadata.lang.DateUtil;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mp4.Mp4Context;
import cn.allbs.metadata.metadata.mp4.boxes.Box;
import cn.allbs.metadata.metadata.mp4.media.Mp4MediaDirectory;
import java.io.IOException;

public abstract class Mp4MediaHandler<T extends Mp4MediaDirectory>
extends Mp4Handler<T> {
    public Mp4MediaHandler(Metadata metadata, Mp4Context context) {
        super(metadata);
        if (context.creationTime != null && context.modificationTime != null) {
            ((Mp4MediaDirectory)this.directory).setDate(101, DateUtil.get1Jan1904EpochDate(context.creationTime));
            ((Mp4MediaDirectory)this.directory).setDate(102, DateUtil.get1Jan1904EpochDate(context.modificationTime));
            ((Mp4MediaDirectory)this.directory).setString(104, context.language);
        }
    }

    @Override
    public boolean shouldAcceptBox(@NotNull Box box) {
        return box.type.equals(this.getMediaInformation()) || box.type.equals("stsd") || box.type.equals("stts");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Box box) {
        return box.type.equals("stbl") || box.type.equals("minf");
    }

    @Override
    public Mp4Handler<?> processBox(@NotNull Box box, @Nullable byte[] payload, Mp4Context context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (box.type.equals(this.getMediaInformation())) {
                this.processMediaInformation(reader, box);
            } else if (box.type.equals("stsd")) {
                this.processSampleDescription(reader, box);
            } else if (box.type.equals("stts")) {
                this.processTimeToSample(reader, box, context);
            }
        }
        return this;
    }

    protected abstract String getMediaInformation();

    protected abstract void processSampleDescription(@NotNull SequentialReader var1, @NotNull Box var2) throws IOException;

    protected abstract void processMediaInformation(@NotNull SequentialReader var1, @NotNull Box var2) throws IOException;

    protected abstract void processTimeToSample(@NotNull SequentialReader var1, @NotNull Box var2, Mp4Context var3) throws IOException;
}

