/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.avi;

import cn.allbs.metadata.imaging.riff.RiffProcessingException;
import cn.allbs.metadata.imaging.riff.RiffReader;
import cn.allbs.metadata.lang.StreamReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.avi.AviRiffHandler;
import cn.allbs.metadata.metadata.file.FileSystemMetadataReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AviMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws IOException, RiffProcessingException {
        Metadata metadata;
        try (FileInputStream inputStream = new FileInputStream(file);){
            metadata = AviMetadataReader.readMetadata(inputStream);
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws IOException, RiffProcessingException {
        Metadata metadata = new Metadata();
        new RiffReader().processRiff(new StreamReader(inputStream), new AviRiffHandler(metadata));
        return metadata;
    }
}

