/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.png;

import cn.allbs.metadata.imaging.png.PngChunk;
import cn.allbs.metadata.imaging.png.PngChunkType;
import cn.allbs.metadata.imaging.png.PngProcessingException;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PngChunkReader {
    private static final byte[] PNG_SIGNATURE_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public Iterable<PngChunk> extract(@NotNull SequentialReader reader, @Nullable Set<PngChunkType> desiredChunkTypes) throws PngProcessingException, IOException {
        reader.setMotorolaByteOrder(true);
        if (!Arrays.equals(PNG_SIGNATURE_BYTES, reader.getBytes(PNG_SIGNATURE_BYTES.length))) {
            throw new PngProcessingException("PNG signature mismatch");
        }
        boolean seenImageHeader = false;
        boolean seenImageTrailer = false;
        ArrayList<PngChunk> chunks = new ArrayList<PngChunk>();
        HashSet<PngChunkType> seenChunkTypes = new HashSet<PngChunkType>();
        while (!seenImageTrailer) {
            byte[] chunkData;
            boolean willStoreChunk;
            int chunkDataLength = reader.getInt32();
            if (chunkDataLength < 0) {
                throw new PngProcessingException("PNG chunk length exceeds maximum");
            }
            PngChunkType chunkType = new PngChunkType(reader.getBytes(4));
            boolean bl = willStoreChunk = desiredChunkTypes == null || desiredChunkTypes.contains(chunkType);
            if (willStoreChunk) {
                chunkData = reader.getBytes(chunkDataLength);
            } else {
                chunkData = null;
                reader.skip(chunkDataLength);
            }
            reader.skip(4L);
            if (willStoreChunk && seenChunkTypes.contains(chunkType) && !chunkType.areMultipleAllowed()) {
                throw new PngProcessingException(String.format("Observed multiple instances of PNG chunk '%s', for which multiples are not allowed", chunkType));
            }
            if (chunkType.equals(PngChunkType.IHDR)) {
                seenImageHeader = true;
            } else if (!seenImageHeader) {
                throw new PngProcessingException(String.format("First chunk should be '%s', but '%s' was observed", PngChunkType.IHDR, chunkType));
            }
            if (chunkType.equals(PngChunkType.IEND)) {
                seenImageTrailer = true;
            }
            if (willStoreChunk) {
                chunks.add(new PngChunk(chunkType, chunkData));
            }
            seenChunkTypes.add(chunkType);
        }
        return chunks;
    }
}

