/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.png;

import cn.allbs.metadata.imaging.png.PngColorType;
import cn.allbs.metadata.imaging.png.PngProcessingException;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import java.io.IOException;

public class PngHeader {
    private final int _imageWidth;
    private final int _imageHeight;
    private final byte _bitsPerSample;
    @NotNull
    private final PngColorType _colorType;
    private final byte _compressionType;
    private final byte _filterMethod;
    private final byte _interlaceMethod;

    public PngHeader(@NotNull byte[] bytes) throws PngProcessingException {
        if (bytes.length != 13) {
            throw new PngProcessingException("PNG header chunk must have 13 data bytes");
        }
        SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
        try {
            this._imageWidth = reader.getInt32();
            this._imageHeight = reader.getInt32();
            this._bitsPerSample = reader.getInt8();
            byte colorTypeNumber = reader.getInt8();
            this._colorType = PngColorType.fromNumericValue(colorTypeNumber);
            this._compressionType = reader.getInt8();
            this._filterMethod = reader.getInt8();
            this._interlaceMethod = reader.getInt8();
        }
        catch (IOException e) {
            throw new PngProcessingException(e);
        }
    }

    public int getImageWidth() {
        return this._imageWidth;
    }

    public int getImageHeight() {
        return this._imageHeight;
    }

    public byte getBitsPerSample() {
        return this._bitsPerSample;
    }

    @NotNull
    public PngColorType getColorType() {
        return this._colorType;
    }

    public byte getCompressionType() {
        return this._compressionType;
    }

    public byte getFilterMethod() {
        return this._filterMethod;
    }

    public byte getInterlaceMethod() {
        return this._interlaceMethod;
    }
}

