/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.raf;

import cn.allbs.metadata.imaging.jpeg.JpegMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegProcessingException;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.file.FileSystemMetadataReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RafMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws JpegProcessingException, IOException {
        Metadata metadata;
        try (FileInputStream inputStream = new FileInputStream(file);){
            metadata = RafMetadataReader.readMetadata(inputStream);
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws JpegProcessingException, IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("Stream must support mark/reset");
        }
        inputStream.mark(512);
        byte[] data = new byte[512];
        int bytesRead = inputStream.read(data);
        if (bytesRead == -1) {
            throw new IOException("Stream is empty");
        }
        inputStream.reset();
        for (int i = 0; i < bytesRead - 2; ++i) {
            if (data[i] != -1 || data[i + 1] != -40 || data[i + 2] != -1) continue;
            long bytesSkipped = inputStream.skip(i);
            if (bytesSkipped == (long)i) break;
            throw new IOException("Skipping stream bytes failed");
        }
        return JpegMetadataReader.readMetadata(inputStream);
    }

    private RafMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

