/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.adobe;

import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.adobe.AdobeJpegDirectory;
import java.io.IOException;
import java.util.Collections;

public class AdobeJpegReader
implements JpegSegmentMetadataReader {
    public static final String PREAMBLE = "Adobe";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPE);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        for (byte[] bytes : segments) {
            if (bytes.length != 12 || !PREAMBLE.equalsIgnoreCase(new String(bytes, 0, PREAMBLE.length()))) continue;
            this.extract(new SequentialByteArrayReader(bytes), metadata);
        }
    }

    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        AdobeJpegDirectory directory = new AdobeJpegDirectory();
        metadata.addDirectory(directory);
        try {
            reader.setMotorolaByteOrder(false);
            if (!reader.getString(PREAMBLE.length()).equals(PREAMBLE)) {
                directory.addError("Invalid Adobe JPEG data header.");
                return;
            }
            directory.setInt(0, reader.getUInt16());
            directory.setInt(1, reader.getUInt16());
            directory.setInt(2, reader.getUInt16());
            directory.setInt(3, reader.getInt8());
        }
        catch (IOException ex) {
            directory.addError("IO exception processing data: " + ex.getMessage());
        }
    }
}

