/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.bmp;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.bmp.BmpHeaderDescriptor;
import java.util.HashMap;

public class BmpHeaderDirectory
extends Directory {
    public static final int TAG_BITMAP_TYPE = -2;
    public static final int TAG_HEADER_SIZE = -1;
    public static final int TAG_IMAGE_HEIGHT = 1;
    public static final int TAG_IMAGE_WIDTH = 2;
    public static final int TAG_COLOUR_PLANES = 3;
    public static final int TAG_BITS_PER_PIXEL = 4;
    public static final int TAG_COMPRESSION = 5;
    public static final int TAG_X_PIXELS_PER_METER = 6;
    public static final int TAG_Y_PIXELS_PER_METER = 7;
    public static final int TAG_PALETTE_COLOUR_COUNT = 8;
    public static final int TAG_IMPORTANT_COLOUR_COUNT = 9;
    public static final int TAG_RENDERING = 10;
    public static final int TAG_COLOR_ENCODING = 11;
    public static final int TAG_RED_MASK = 12;
    public static final int TAG_GREEN_MASK = 13;
    public static final int TAG_BLUE_MASK = 14;
    public static final int TAG_ALPHA_MASK = 15;
    public static final int TAG_COLOR_SPACE_TYPE = 16;
    public static final int TAG_GAMMA_RED = 17;
    public static final int TAG_GAMMA_GREEN = 18;
    public static final int TAG_GAMMA_BLUE = 19;
    public static final int TAG_INTENT = 20;
    public static final int TAG_LINKED_PROFILE = 21;
    @NotNull
    private static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public BmpHeaderDirectory() {
        this.setDescriptor(new BmpHeaderDescriptor(this));
    }

    @Nullable
    public BitmapType getBitmapType() {
        Integer value = this.getInteger(-2);
        return value == null ? null : BitmapType.typeOf(value);
    }

    @Nullable
    public Compression getCompression() {
        return Compression.typeOf(this);
    }

    @Nullable
    public RenderingHalftoningAlgorithm getRendering() {
        Integer value = this.getInteger(10);
        return value == null ? null : RenderingHalftoningAlgorithm.typeOf(value);
    }

    @Nullable
    public ColorEncoding getColorEncoding() {
        Integer value = this.getInteger(11);
        return value == null ? null : ColorEncoding.typeOf(value);
    }

    @Nullable
    public ColorSpaceType getColorSpaceType() {
        Long value = this.getLongObject(16);
        return value == null ? null : ColorSpaceType.typeOf(value);
    }

    @Nullable
    public RenderingIntent getRenderingIntent() {
        Integer value = this.getInteger(20);
        return value == null ? null : RenderingIntent.typeOf(value.intValue());
    }

    @Override
    @NotNull
    public String getName() {
        return "BMP Header";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    static {
        _tagNameMap.put(-2, "Bitmap type");
        _tagNameMap.put(-1, "Header Size");
        _tagNameMap.put(1, "Image Height");
        _tagNameMap.put(2, "Image Width");
        _tagNameMap.put(3, "Planes");
        _tagNameMap.put(4, "Bits Per Pixel");
        _tagNameMap.put(5, "Compression");
        _tagNameMap.put(6, "X Pixels per Meter");
        _tagNameMap.put(7, "Y Pixels per Meter");
        _tagNameMap.put(8, "Palette Colour Count");
        _tagNameMap.put(9, "Important Colour Count");
        _tagNameMap.put(10, "Rendering");
        _tagNameMap.put(11, "Color Encoding");
        _tagNameMap.put(12, "Red Mask");
        _tagNameMap.put(13, "Green Mask");
        _tagNameMap.put(14, "Blue Mask");
        _tagNameMap.put(15, "Alpha Mask");
        _tagNameMap.put(16, "Color Space Type");
        _tagNameMap.put(17, "Red Gamma Curve");
        _tagNameMap.put(18, "Green Gamma Curve");
        _tagNameMap.put(19, "Blue Gamma Curve");
        _tagNameMap.put(20, "Rendering Intent");
        _tagNameMap.put(21, "Linked Profile File Name");
    }

    public static enum RenderingIntent {
        LCS_GM_BUSINESS(1),
        LCS_GM_GRAPHICS(2),
        LCS_GM_IMAGES(4),
        LCS_GM_ABS_COLORIMETRIC(8);

        private final int value;

        private RenderingIntent(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static RenderingIntent typeOf(long value) {
            for (RenderingIntent renderingIntent : RenderingIntent.values()) {
                if ((long)renderingIntent.value != value) continue;
                return renderingIntent;
            }
            return null;
        }

        @NotNull
        public String toString() {
            switch (this) {
                case LCS_GM_BUSINESS: {
                    return "Graphic, Saturation";
                }
                case LCS_GM_GRAPHICS: {
                    return "Proof, Relative Colorimetric";
                }
                case LCS_GM_IMAGES: {
                    return "Picture, Perceptual";
                }
                case LCS_GM_ABS_COLORIMETRIC: {
                    return "Match, Absolute Colorimetric";
                }
            }
            throw new IllegalStateException("Unimplemented rendering intent " + super.toString());
        }
    }

    public static enum ColorSpaceType {
        LCS_CALIBRATED_RGB(0L),
        LCS_sRGB(1934772034L),
        LCS_WINDOWS_COLOR_SPACE(1466527264L),
        PROFILE_LINKED(1279872587L),
        PROFILE_EMBEDDED(1296188740L);

        private final long value;

        private ColorSpaceType(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        @Nullable
        public static ColorSpaceType typeOf(long value) {
            for (ColorSpaceType colorSpaceType : ColorSpaceType.values()) {
                if (colorSpaceType.value != value) continue;
                return colorSpaceType;
            }
            return null;
        }

        @NotNull
        public String toString() {
            switch (this) {
                case LCS_CALIBRATED_RGB: {
                    return "Calibrated RGB";
                }
                case LCS_sRGB: {
                    return "sRGB Color Space";
                }
                case LCS_WINDOWS_COLOR_SPACE: {
                    return "System Default Color Space, sRGB";
                }
                case PROFILE_LINKED: {
                    return "Linked Profile";
                }
                case PROFILE_EMBEDDED: {
                    return "Embedded Profile";
                }
            }
            throw new IllegalStateException("Unimplemented color space type " + super.toString());
        }
    }

    public static enum ColorEncoding {
        RGB(0);

        private final int value;

        private ColorEncoding(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static ColorEncoding typeOf(int value) {
            return value == 0 ? RGB : null;
        }
    }

    public static enum RenderingHalftoningAlgorithm {
        NONE(0),
        ERROR_DIFFUSION(1),
        PANDA(2),
        SUPER_CIRCLE(3);

        private final int value;

        private RenderingHalftoningAlgorithm(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static RenderingHalftoningAlgorithm typeOf(int value) {
            for (RenderingHalftoningAlgorithm renderingHalftoningAlgorithm : RenderingHalftoningAlgorithm.values()) {
                if (renderingHalftoningAlgorithm.value != value) continue;
                return renderingHalftoningAlgorithm;
            }
            return null;
        }

        @NotNull
        public String toString() {
            switch (this) {
                case NONE: {
                    return "No Halftoning Algorithm";
                }
                case ERROR_DIFFUSION: {
                    return "Error Diffusion Halftoning";
                }
                case PANDA: {
                    return "Processing Algorithm for Noncoded Document Acquisition";
                }
                case SUPER_CIRCLE: {
                    return "Super-circle Halftoning";
                }
            }
            throw new IllegalStateException("Unimplemented rendering halftoning algorithm type " + super.toString());
        }
    }

    public static enum Compression {
        BI_RGB(0),
        BI_RLE8(1),
        BI_RLE4(2),
        BI_BITFIELDS(3),
        BI_HUFFMAN_1D(3),
        BI_JPEG(4),
        BI_RLE24(4),
        BI_PNG(5),
        BI_ALPHABITFIELDS(6),
        BI_CMYK(11),
        BI_CMYKRLE8(12),
        BI_CMYKRLE4(13);

        private final int value;

        private Compression(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static Compression typeOf(@NotNull BmpHeaderDirectory directory) {
            Integer value = directory.getInteger(5);
            if (value == null) {
                return null;
            }
            Integer headerSize = directory.getInteger(-1);
            if (headerSize == null) {
                return null;
            }
            return Compression.typeOf(value, headerSize);
        }

        @Nullable
        public static Compression typeOf(int value, int headerSize) {
            switch (value) {
                case 0: {
                    return BI_RGB;
                }
                case 1: {
                    return BI_RLE8;
                }
                case 2: {
                    return BI_RLE4;
                }
                case 3: {
                    return headerSize == 64 ? BI_HUFFMAN_1D : BI_BITFIELDS;
                }
                case 4: {
                    return headerSize == 64 ? BI_RLE24 : BI_JPEG;
                }
                case 5: {
                    return BI_PNG;
                }
                case 6: {
                    return BI_ALPHABITFIELDS;
                }
                case 11: {
                    return BI_CMYK;
                }
                case 12: {
                    return BI_CMYKRLE8;
                }
                case 13: {
                    return BI_CMYKRLE4;
                }
            }
            return null;
        }

        @NotNull
        public String toString() {
            switch (this) {
                case BI_RGB: {
                    return "None";
                }
                case BI_RLE8: {
                    return "RLE 8-bit/pixel";
                }
                case BI_RLE4: {
                    return "RLE 4-bit/pixel";
                }
                case BI_BITFIELDS: {
                    return "Bit Fields";
                }
                case BI_HUFFMAN_1D: {
                    return "Huffman 1D";
                }
                case BI_JPEG: {
                    return "JPEG";
                }
                case BI_RLE24: {
                    return "RLE 24-bit/pixel";
                }
                case BI_PNG: {
                    return "PNG";
                }
                case BI_ALPHABITFIELDS: {
                    return "RGBA Bit Fields";
                }
                case BI_CMYK: {
                    return "CMYK Uncompressed";
                }
                case BI_CMYKRLE8: {
                    return "CMYK RLE-8";
                }
                case BI_CMYKRLE4: {
                    return "CMYK RLE-4";
                }
            }
            throw new IllegalStateException("Unimplemented compression type " + super.toString());
        }
    }

    public static enum BitmapType {
        BITMAP(19778),
        OS2_BITMAP_ARRAY(16706),
        OS2_ICON(17225),
        OS2_COLOR_ICON(18755),
        OS2_COLOR_POINTER(20547),
        OS2_POINTER(21584);

        private final int value;

        private BitmapType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static BitmapType typeOf(int value) {
            for (BitmapType bitmapType : BitmapType.values()) {
                if (bitmapType.value != value) continue;
                return bitmapType;
            }
            return null;
        }

        @NotNull
        public String toString() {
            switch (this) {
                case BITMAP: {
                    return "Standard";
                }
                case OS2_BITMAP_ARRAY: {
                    return "Bitmap Array";
                }
                case OS2_COLOR_ICON: {
                    return "Color Icon";
                }
                case OS2_COLOR_POINTER: {
                    return "Color Pointer";
                }
                case OS2_ICON: {
                    return "Monochrome Icon";
                }
                case OS2_POINTER: {
                    return "Monochrome Pointer";
                }
            }
            throw new IllegalStateException("Unimplemented bitmap type " + super.toString());
        }
    }
}

