/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif.makernotes;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.makernotes.OlympusImageProcessingMakernoteDirectory;

public class OlympusImageProcessingMakernoteDescriptor
extends TagDescriptor<OlympusImageProcessingMakernoteDirectory> {
    public OlympusImageProcessingMakernoteDescriptor(@NotNull OlympusImageProcessingMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getImageProcessingVersionDescription();
            }
            case 512: {
                return this.getColorMatrixDescription();
            }
            case 4112: {
                return this.getNoiseReduction2Description();
            }
            case 4113: {
                return this.getDistortionCorrection2Description();
            }
            case 4114: {
                return this.getShadingCompensation2Description();
            }
            case 4124: {
                return this.getMultipleExposureModeDescription();
            }
            case 4370: {
                return this.getAspectRatioDescription();
            }
            case 6400: {
                return this.getKeystoneCompensationDescription();
            }
            case 6401: {
                return this.getKeystoneDirectionDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getImageProcessingVersionDescription() {
        return this.getVersionBytesDescription(0, 4);
    }

    @Nullable
    public String getColorMatrixDescription() {
        int[] obj = ((OlympusImageProcessingMakernoteDirectory)this._directory).getIntArray(512);
        if (obj == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < obj.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append((short)obj[i]);
        }
        return sb.toString();
    }

    @Nullable
    public String getNoiseReduction2Description() {
        Integer value = ((OlympusImageProcessingMakernoteDirectory)this._directory).getInteger(4112);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        short v = value.shortValue();
        if ((v & 1) != 0) {
            sb.append("Noise Reduction, ");
        }
        if ((v >> 1 & 1) != 0) {
            sb.append("Noise Filter, ");
        }
        if ((v >> 2 & 1) != 0) {
            sb.append("Noise Filter (ISO Boost), ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getDistortionCorrection2Description() {
        return this.getIndexedDescription(4113, "Off", "On");
    }

    @Nullable
    public String getShadingCompensation2Description() {
        return this.getIndexedDescription(4114, "Off", "On");
    }

    @Nullable
    public String getMultipleExposureModeDescription() {
        int[] values = ((OlympusImageProcessingMakernoteDirectory)this._directory).getIntArray(4124);
        if (values == null) {
            Integer value = ((OlympusImageProcessingMakernoteDirectory)this._directory).getInteger(4124);
            if (value == null) {
                return null;
            }
            values = new int[]{value};
        }
        if (values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch ((short)values[0]) {
            case 0: {
                sb.append("Off");
                break;
            }
            case 2: {
                sb.append("On (2 frames)");
                break;
            }
            case 3: {
                sb.append("On (3 frames)");
                break;
            }
            default: {
                sb.append("Unknown (").append((short)values[0]).append(")");
            }
        }
        if (values.length > 1) {
            sb.append("; ").append((short)values[1]);
        }
        return sb.toString();
    }

    @Nullable
    public String getAspectRatioDescription() {
        byte[] values = ((OlympusImageProcessingMakernoteDirectory)this._directory).getByteArray(4370);
        if (values == null || values.length < 2) {
            return null;
        }
        String join = String.format("%d %d", values[0], values[1]);
        String ret = join.equals("1 1") ? "4:3" : (join.equals("1 4") ? "1:1" : (join.equals("2 1") ? "3:2 (RAW)" : (join.equals("2 2") ? "3:2" : (join.equals("3 1") ? "16:9 (RAW)" : (join.equals("3 3") ? "16:9" : (join.equals("4 1") ? "1:1 (RAW)" : (join.equals("4 4") ? "6:6" : (join.equals("5 5") ? "5:4" : (join.equals("6 6") ? "7:6" : (join.equals("7 7") ? "6:5" : (join.equals("8 8") ? "7:5" : (join.equals("9 1") ? "3:4 (RAW)" : (join.equals("9 9") ? "3:4" : "Unknown (" + join + ")")))))))))))));
        return ret;
    }

    @Nullable
    public String getKeystoneCompensationDescription() {
        byte[] values = ((OlympusImageProcessingMakernoteDirectory)this._directory).getByteArray(6400);
        if (values == null || values.length < 2) {
            return null;
        }
        String join = String.format("%d %d", values[0], values[1]);
        String ret = join.equals("0 0") ? "Off" : (join.equals("0 1") ? "On" : "Unknown (" + join + ")");
        return ret;
    }

    @Nullable
    public String getKeystoneDirectionDescription() {
        return this.getIndexedDescription(6401, "Vertical", "Horizontal");
    }
}

