/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif.makernotes;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.makernotes.PentaxMakernoteDirectory;

public class PentaxMakernoteDescriptor
extends TagDescriptor<PentaxMakernoteDirectory> {
    public PentaxMakernoteDescriptor(@NotNull PentaxMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getCaptureModeDescription();
            }
            case 2: {
                return this.getQualityLevelDescription();
            }
            case 3: {
                return this.getFocusModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getIsoSpeedDescription();
            }
            case 23: {
                return this.getColourDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getColourDescription() {
        return this.getIndexedDescription(23, 1, "Normal", "Black & White", "Sepia");
    }

    @Nullable
    public String getIsoSpeedDescription() {
        Integer value = ((PentaxMakernoteDirectory)this._directory).getInteger(20);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 10: {
                return "ISO 100";
            }
            case 16: {
                return "ISO 200";
            }
            case 100: {
                return "ISO 100";
            }
            case 200: {
                return "ISO 200";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        return this.getIndexedDescription(13, "Normal", "Low", "High");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(12, "Normal", "Low", "High");
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(11, "Normal", "Soft", "Hard");
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Float value = ((PentaxMakernoteDirectory)this._directory).getFloatObject(10);
        if (value == null) {
            return null;
        }
        if (value.floatValue() == 0.0f) {
            return "Off";
        }
        return Float.toString(value.floatValue());
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        return this.getIndexedDescription(7, "Auto", "Daylight", "Shade", "Tungsten", "Fluorescent", "Manual");
    }

    @Nullable
    public String getFlashModeDescription() {
        return this.getIndexedDescription(4, 1, "Auto", "Flash On", null, "Flash Off", null, "Red-eye Reduction");
    }

    @Nullable
    public String getFocusModeDescription() {
        return this.getIndexedDescription(3, 2, "Custom", "Auto");
    }

    @Nullable
    public String getQualityLevelDescription() {
        return this.getIndexedDescription(2, "Good", "Better", "Best");
    }

    @Nullable
    public String getCaptureModeDescription() {
        return this.getIndexedDescription(1, "Auto", "Night-scene", "Manual", null, "Multiple");
    }
}

