/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif.makernotes;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.makernotes.SonyType1MakernoteDirectory;

public class SonyType1MakernoteDescriptor
extends TagDescriptor<SonyType1MakernoteDirectory> {
    public SonyType1MakernoteDescriptor(@NotNull SonyType1MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 258: {
                return this.getImageQualityDescription();
            }
            case 260: {
                return this.getFlashExposureCompensationDescription();
            }
            case 261: {
                return this.getTeleconverterDescription();
            }
            case 277: {
                return this.getWhiteBalanceDescription();
            }
            case 45089: {
                return this.getColorTemperatureDescription();
            }
            case 45091: {
                return this.getSceneModeDescription();
            }
            case 45092: {
                return this.getZoneMatchingDescription();
            }
            case 45093: {
                return this.getDynamicRangeOptimizerDescription();
            }
            case 45094: {
                return this.getImageStabilizationDescription();
            }
            case 45097: {
                return this.getColorModeDescription();
            }
            case 45120: {
                return this.getMacroDescription();
            }
            case 45121: {
                return this.getExposureModeDescription();
            }
            case 45127: {
                return this.getJpegQualityDescription();
            }
            case 45131: {
                return this.getAntiBlurDescription();
            }
            case 45134: {
                return this.getLongExposureNoiseReductionDescription();
            }
            case 8201: {
                return this.getHighIsoNoiseReductionDescription();
            }
            case 8206: {
                return this.getPictureEffectDescription();
            }
            case 8207: {
                return this.getSoftSkinEffectDescription();
            }
            case 8209: {
                return this.getVignettingCorrectionDescription();
            }
            case 8210: {
                return this.getLateralChromaticAberrationDescription();
            }
            case 8211: {
                return this.getDistortionCorrectionDescription();
            }
            case 8214: {
                return this.getAutoPortraitFramedDescription();
            }
            case 8219: {
                return this.getFocusModeDescription();
            }
            case 8222: {
                return this.getAFPointSelectedDescription();
            }
            case 45057: {
                return this.getSonyModelIdDescription();
            }
            case 45123: {
                return this.getAFModeDescription();
            }
            case 45124: {
                return this.getAFIlluminatorDescription();
            }
            case 45128: {
                return this.getFlashLevelDescription();
            }
            case 45129: {
                return this.getReleaseModeDescription();
            }
            case 45130: {
                return this.getSequenceNumberDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getImageQualityDescription() {
        return this.getIndexedDescription(258, "RAW", "Super Fine", "Fine", "Standard", "Economy", "Extra Fine", "RAW + JPEG", "Compressed RAW", "Compressed RAW + JPEG");
    }

    @Nullable
    public String getFlashExposureCompensationDescription() {
        return this.getFormattedInt(260, "%d EV");
    }

    @Nullable
    public String getTeleconverterDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(261);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "None";
            }
            case 72: {
                return "Minolta/Sony AF 2x APO (D)";
            }
            case 80: {
                return "Minolta AF 2x APO II";
            }
            case 96: {
                return "Minolta AF 2x APO";
            }
            case 136: {
                return "Minolta/Sony AF 1.4x APO (D)";
            }
            case 144: {
                return "Minolta AF 1.4x APO II";
            }
            case 160: {
                return "Minolta AF 1.4x APO";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(277);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Color Temperature/Color Filter";
            }
            case 16: {
                return "Daylight";
            }
            case 32: {
                return "Cloudy";
            }
            case 48: {
                return "Shade";
            }
            case 64: {
                return "Tungsten";
            }
            case 80: {
                return "Flash";
            }
            case 96: {
                return "Fluorescent";
            }
            case 112: {
                return "Custom";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getColorTemperatureDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45089);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Auto";
        }
        int kelvin = (value & 0xFF0000) >> 8 | (value & 0xFF000000) >> 24;
        return String.format("%d K", kelvin);
    }

    @Nullable
    public String getZoneMatchingDescription() {
        return this.getIndexedDescription(45092, "ISO Setting Used", "High Key", "Low Key");
    }

    @Nullable
    public String getDynamicRangeOptimizerDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45093);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Standard";
            }
            case 2: {
                return "Advanced Auto";
            }
            case 3: {
                return "Auto";
            }
            case 8: {
                return "Advanced LV1";
            }
            case 9: {
                return "Advanced LV2";
            }
            case 10: {
                return "Advanced LV3";
            }
            case 11: {
                return "Advanced LV4";
            }
            case 12: {
                return "Advanced LV5";
            }
            case 16: {
                return "LV1";
            }
            case 17: {
                return "LV2";
            }
            case 18: {
                return "LV3";
            }
            case 19: {
                return "LV4";
            }
            case 20: {
                return "LV5";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getImageStabilizationDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45094);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "N/A";
    }

    @Nullable
    public String getColorModeDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45097);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Vivid";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Landscape";
            }
            case 4: {
                return "Sunset";
            }
            case 5: {
                return "Night Portrait";
            }
            case 6: {
                return "Black & White";
            }
            case 7: {
                return "Adobe RGB";
            }
            case 12: 
            case 100: {
                return "Neutral";
            }
            case 13: 
            case 101: {
                return "Clear";
            }
            case 14: 
            case 102: {
                return "Deep";
            }
            case 15: 
            case 103: {
                return "Light";
            }
            case 16: {
                return "Autumn";
            }
            case 17: {
                return "Sepia";
            }
            case 104: {
                return "Night View";
            }
            case 105: {
                return "Autumn Leaves";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getMacroDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45120);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Magnifying Glass/Super Macro";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getExposureModeDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45121);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Program";
            }
            case 1: {
                return "Portrait";
            }
            case 2: {
                return "Beach";
            }
            case 3: {
                return "Sports";
            }
            case 4: {
                return "Snow";
            }
            case 5: {
                return "Landscape";
            }
            case 6: {
                return "Auto";
            }
            case 7: {
                return "Aperture Priority";
            }
            case 8: {
                return "Shutter Priority";
            }
            case 9: {
                return "Night Scene / Twilight";
            }
            case 10: {
                return "Hi-Speed Shutter";
            }
            case 11: {
                return "Twilight Portrait";
            }
            case 12: {
                return "Soft Snap/Portrait";
            }
            case 13: {
                return "Fireworks";
            }
            case 14: {
                return "Smile Shutter";
            }
            case 15: {
                return "Manual";
            }
            case 18: {
                return "High Sensitivity";
            }
            case 19: {
                return "Macro";
            }
            case 20: {
                return "Advanced Sports Shooting";
            }
            case 29: {
                return "Underwater";
            }
            case 33: {
                return "Food";
            }
            case 34: {
                return "Panorama";
            }
            case 35: {
                return "Handheld Night Shot";
            }
            case 36: {
                return "Anti Motion Blur";
            }
            case 37: {
                return "Pet";
            }
            case 38: {
                return "Backlight Correction HDR";
            }
            case 39: {
                return "Superior Auto";
            }
            case 40: {
                return "Background Defocus";
            }
            case 41: {
                return "Soft Skin";
            }
            case 42: {
                return "3D Image";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getJpegQualityDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45127);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Fine";
            }
            case 2: {
                return "Extra Fine";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getAntiBlurDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45131);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On (Continuous)";
            }
            case 2: {
                return "On (Shooting)";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getLongExposureNoiseReductionDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45134);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getHighIsoNoiseReductionDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(8201);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Normal";
            }
            case 3: {
                return "High";
            }
            case 256: {
                return "Auto";
            }
            case 65535: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getPictureEffectDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(8206);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Toy Camera";
            }
            case 2: {
                return "Pop Color";
            }
            case 3: {
                return "Posterization";
            }
            case 4: {
                return "Posterization B/W";
            }
            case 5: {
                return "Retro Photo";
            }
            case 6: {
                return "Soft High Key";
            }
            case 7: {
                return "Partial Color (red)";
            }
            case 8: {
                return "Partial Color (green)";
            }
            case 9: {
                return "Partial Color (blue)";
            }
            case 10: {
                return "Partial Color (yellow)";
            }
            case 13: {
                return "High Contrast Monochrome";
            }
            case 16: {
                return "Toy Camera (normal)";
            }
            case 17: {
                return "Toy Camera (cool)";
            }
            case 18: {
                return "Toy Camera (warm)";
            }
            case 19: {
                return "Toy Camera (green)";
            }
            case 20: {
                return "Toy Camera (magenta)";
            }
            case 32: {
                return "Soft Focus (low)";
            }
            case 33: {
                return "Soft Focus";
            }
            case 34: {
                return "Soft Focus (high)";
            }
            case 48: {
                return "Miniature (auto)";
            }
            case 49: {
                return "Miniature (top)";
            }
            case 50: {
                return "Miniature (middle horizontal)";
            }
            case 51: {
                return "Miniature (bottom)";
            }
            case 52: {
                return "Miniature (left)";
            }
            case 53: {
                return "Miniature (middle vertical)";
            }
            case 54: {
                return "Miniature (right)";
            }
            case 64: {
                return "HDR Painting (low)";
            }
            case 65: {
                return "HDR Painting";
            }
            case 66: {
                return "HDR Painting (high)";
            }
            case 80: {
                return "Rich-tone Monochrome";
            }
            case 97: {
                return "Water Color";
            }
            case 98: {
                return "Water Color 2";
            }
            case 112: {
                return "Illustration (low)";
            }
            case 113: {
                return "Illustration";
            }
            case 114: {
                return "Illustration (high)";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getSoftSkinEffectDescription() {
        return this.getIndexedDescription(8207, "Off", "Low", "Mid", "High");
    }

    @Nullable
    public String getVignettingCorrectionDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(8209);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 2: {
                return "Auto";
            }
            case -1: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getLateralChromaticAberrationDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(8210);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 2: {
                return "Auto";
            }
            case -1: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getDistortionCorrectionDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(8211);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 2: {
                return "Auto";
            }
            case -1: {
                return "N/A";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getAutoPortraitFramedDescription() {
        return this.getIndexedDescription(8214, "No", "Yes");
    }

    @Nullable
    public String getFocusModeDescription() {
        return this.getIndexedDescription(8219, "Manual", null, "AF-A", "AF-C", "AF-S", null, "DMF", "AF-D");
    }

    @Nullable
    public String getAFPointSelectedDescription() {
        return this.getIndexedDescription(8222, "Auto", "Center", "Top", "Upper-right", "Right", "Lower-right", "Bottom", "Lower-left", "Left", "Upper-left\t  \t", "Far Right", "Far Left", "Upper-middle", "Near Right", "Lower-middle", "Near Left", "Upper Far Right", "Lower Far Right", "Lower Far Left", "Upper Far Left");
    }

    @Nullable
    public String getSonyModelIdDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45057);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "DSC-R1";
            }
            case 256: {
                return "DSLR-A100";
            }
            case 257: {
                return "DSLR-A900";
            }
            case 258: {
                return "DSLR-A700";
            }
            case 259: {
                return "DSLR-A200";
            }
            case 260: {
                return "DSLR-A350";
            }
            case 261: {
                return "DSLR-A300";
            }
            case 262: {
                return "DSLR-A900 (APS-C mode)";
            }
            case 263: {
                return "DSLR-A380/A390";
            }
            case 264: {
                return "DSLR-A330";
            }
            case 265: {
                return "DSLR-A230";
            }
            case 266: {
                return "DSLR-A290";
            }
            case 269: {
                return "DSLR-A850";
            }
            case 270: {
                return "DSLR-A850 (APS-C mode)";
            }
            case 273: {
                return "DSLR-A550";
            }
            case 274: {
                return "DSLR-A500";
            }
            case 275: {
                return "DSLR-A450";
            }
            case 278: {
                return "NEX-5";
            }
            case 279: {
                return "NEX-3";
            }
            case 280: {
                return "SLT-A33";
            }
            case 281: {
                return "SLT-A55V";
            }
            case 282: {
                return "DSLR-A560";
            }
            case 283: {
                return "DSLR-A580";
            }
            case 284: {
                return "NEX-C3";
            }
            case 285: {
                return "SLT-A35";
            }
            case 286: {
                return "SLT-A65V";
            }
            case 287: {
                return "SLT-A77V";
            }
            case 288: {
                return "NEX-5N";
            }
            case 289: {
                return "NEX-7";
            }
            case 290: {
                return "NEX-VG20E";
            }
            case 291: {
                return "SLT-A37";
            }
            case 292: {
                return "SLT-A57";
            }
            case 293: {
                return "NEX-F3";
            }
            case 294: {
                return "SLT-A99V";
            }
            case 295: {
                return "NEX-6";
            }
            case 296: {
                return "NEX-5R";
            }
            case 297: {
                return "DSC-RX100";
            }
            case 298: {
                return "DSC-RX1";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSceneModeDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45091);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Portrait";
            }
            case 2: {
                return "Text";
            }
            case 3: {
                return "Night Scene";
            }
            case 4: {
                return "Sunset";
            }
            case 5: {
                return "Sports";
            }
            case 6: {
                return "Landscape";
            }
            case 7: {
                return "Night Portrait";
            }
            case 8: {
                return "Macro";
            }
            case 9: {
                return "Super Macro";
            }
            case 16: {
                return "Auto";
            }
            case 17: {
                return "Night View/Portrait";
            }
            case 18: {
                return "Sweep Panorama";
            }
            case 19: {
                return "Handheld Night Shot";
            }
            case 20: {
                return "Anti Motion Blur";
            }
            case 21: {
                return "Cont. Priority AE";
            }
            case 22: {
                return "Auto+";
            }
            case 23: {
                return "3D Sweep Panorama";
            }
            case 24: {
                return "Superior Auto";
            }
            case 25: {
                return "High Sensitivity";
            }
            case 26: {
                return "Fireworks";
            }
            case 27: {
                return "Food";
            }
            case 28: {
                return "Pet";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAFModeDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45123);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Default";
            }
            case 1: {
                return "Multi";
            }
            case 2: {
                return "Center";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Flexible Spot";
            }
            case 6: {
                return "Touch";
            }
            case 14: {
                return "Manual Focus";
            }
            case 15: {
                return "Face Detected";
            }
            case 65535: {
                return "n/a";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAFIlluminatorDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45124);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Auto";
            }
            case 65535: {
                return "n/a";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashLevelDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45128);
        if (value == null) {
            return null;
        }
        switch (value) {
            case -32768: {
                return "Low";
            }
            case -3: {
                return "-3/3";
            }
            case -2: {
                return "-2/3";
            }
            case -1: {
                return "-1/3";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "+1/3";
            }
            case 2: {
                return "+2/3";
            }
            case 3: {
                return "+3/3";
            }
            case 128: {
                return "n/a";
            }
            case 32767: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getReleaseModeDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45129);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 2: {
                return "Continuous";
            }
            case 5: {
                return "Exposure Bracketing";
            }
            case 6: {
                return "White Balance Bracketing";
            }
            case 65535: {
                return "n/a";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSequenceNumberDescription() {
        Integer value = ((SonyType1MakernoteDirectory)this._directory).getInteger(45129);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Single";
            }
            case 65535: {
                return "n/a";
            }
        }
        return value.toString();
    }
}

