/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.icc;

import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.DateUtil;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.MetadataReader;
import cn.allbs.metadata.metadata.icc.IccDirectory;
import java.io.IOException;
import java.util.Collections;

public class IccReader
implements JpegSegmentMetadataReader,
MetadataReader {
    public static final String JPEG_SEGMENT_PREAMBLE = "ICC_PROFILE";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP2);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        int preambleLength = JPEG_SEGMENT_PREAMBLE.length();
        byte[] buffer = null;
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length < preambleLength || !JPEG_SEGMENT_PREAMBLE.equalsIgnoreCase(new String(segmentBytes, 0, preambleLength))) continue;
            if (buffer == null) {
                buffer = new byte[segmentBytes.length - 14];
                System.arraycopy(segmentBytes, 14, buffer, 0, segmentBytes.length - 14);
                continue;
            }
            byte[] newBuffer = new byte[buffer.length + segmentBytes.length - 14];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            System.arraycopy(segmentBytes, 14, newBuffer, buffer.length, segmentBytes.length - 14);
            buffer = newBuffer;
        }
        if (buffer != null) {
            this.extract(new ByteArrayReader(buffer), metadata);
        }
    }

    @Override
    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        this.extract(reader, metadata, null);
    }

    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata, @Nullable Directory parentDirectory) {
        IccDirectory directory = new IccDirectory();
        if (parentDirectory != null) {
            directory.setParent(parentDirectory);
        }
        try {
            int profileByteCount = reader.getInt32(0);
            directory.setInt(0, profileByteCount);
            this.set4ByteString(directory, 4, reader);
            this.setInt32(directory, 8, reader);
            this.set4ByteString(directory, 12, reader);
            this.set4ByteString(directory, 16, reader);
            this.set4ByteString(directory, 20, reader);
            this.setDate(directory, 24, reader);
            this.set4ByteString(directory, 36, reader);
            this.set4ByteString(directory, 40, reader);
            this.setInt32(directory, 44, reader);
            this.set4ByteString(directory, 48, reader);
            int temp = reader.getInt32(52);
            if (temp != 0) {
                if (temp <= 0x20202020) {
                    directory.setInt(52, temp);
                } else {
                    directory.setString(52, IccReader.getStringFromInt32(temp));
                }
            }
            this.setInt32(directory, 64, reader);
            this.setInt64(directory, 56, reader);
            float[] xyz = new float[]{reader.getS15Fixed16(68), reader.getS15Fixed16(72), reader.getS15Fixed16(76)};
            directory.setObject(68, xyz);
            int tagCount = reader.getInt32(128);
            directory.setInt(128, tagCount);
            for (int i = 0; i < tagCount; ++i) {
                int pos = 132 + i * 12;
                int tagType = reader.getInt32(pos);
                int tagPtr = reader.getInt32(pos + 4);
                int tagLen = reader.getInt32(pos + 8);
                byte[] b = reader.getBytes(tagPtr, tagLen);
                directory.setByteArray(tagType, b);
            }
        }
        catch (IOException ex) {
            directory.addError("Exception reading ICC profile: " + ex.getMessage());
        }
        metadata.addDirectory(directory);
    }

    private void set4ByteString(@NotNull Directory directory, int tagType, @NotNull RandomAccessReader reader) throws IOException {
        int i = reader.getInt32(tagType);
        if (i != 0) {
            directory.setString(tagType, IccReader.getStringFromInt32(i));
        }
    }

    private void setInt32(@NotNull Directory directory, int tagType, @NotNull RandomAccessReader reader) throws IOException {
        int i = reader.getInt32(tagType);
        if (i != 0) {
            directory.setInt(tagType, i);
        }
    }

    private void setInt64(@NotNull Directory directory, int tagType, @NotNull RandomAccessReader reader) throws IOException {
        long l = reader.getInt64(tagType);
        if (l != 0L) {
            directory.setLong(tagType, l);
        }
    }

    private void setDate(@NotNull IccDirectory directory, int tagType, @NotNull RandomAccessReader reader) throws IOException {
        int y = reader.getUInt16(tagType);
        int m = reader.getUInt16(tagType + 2);
        int d = reader.getUInt16(tagType + 4);
        int h = reader.getUInt16(tagType + 6);
        int M = reader.getUInt16(tagType + 8);
        int s = reader.getUInt16(tagType + 10);
        if (DateUtil.isValidDate(y, m - 1, d) && DateUtil.isValidTime(h, M, s)) {
            String dateString = String.format("%04d:%02d:%02d %02d:%02d:%02d", y, m, d, h, M, s);
            directory.setString(tagType, dateString);
        } else {
            directory.addError(String.format("ICC data describes an invalid date/time: year=%d month=%d day=%d hour=%d minute=%d second=%d", y, m, d, h, M, s));
        }
    }

    @NotNull
    public static String getStringFromInt32(int d) {
        byte[] b = new byte[]{(byte)((d & 0xFF000000) >> 24), (byte)((d & 0xFF0000) >> 16), (byte)((d & 0xFF00) >> 8), (byte)(d & 0xFF)};
        return new String(b);
    }
}

