/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mov;

import cn.allbs.metadata.imaging.quicktime.QuickTimeHandler;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mov.QuickTimeContext;
import cn.allbs.metadata.metadata.mov.QuickTimeDirectory;
import cn.allbs.metadata.metadata.mov.QuickTimeHandlerFactory;
import cn.allbs.metadata.metadata.mov.atoms.Atom;
import cn.allbs.metadata.metadata.mov.atoms.FileTypeCompatibilityAtom;
import cn.allbs.metadata.metadata.mov.atoms.HandlerReferenceAtom;
import cn.allbs.metadata.metadata.mov.atoms.MediaHeaderAtom;
import cn.allbs.metadata.metadata.mov.atoms.MovieHeaderAtom;
import cn.allbs.metadata.metadata.mov.atoms.TrackHeaderAtom;
import cn.allbs.metadata.metadata.mov.atoms.canon.CanonThumbnailAtom;
import cn.allbs.metadata.metadata.xmp.XmpReader;
import java.io.IOException;

public class QuickTimeAtomHandler
extends QuickTimeHandler<QuickTimeDirectory> {
    private QuickTimeHandlerFactory handlerFactory = new QuickTimeHandlerFactory(this);

    public QuickTimeAtomHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    @NotNull
    protected QuickTimeDirectory getDirectory() {
        return new QuickTimeDirectory();
    }

    @Override
    public boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals("ftyp") || atom.type.equals("mvhd") || atom.type.equals("hdlr") || atom.type.equals("mdhd") || atom.type.equals("CNTH") || atom.type.equals("XMP_") || atom.type.equals("tkhd");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Atom atom) {
        return atom.type.equals("trak") || atom.type.equals("udta") || atom.type.equals("meta") || atom.type.equals("moov") || atom.type.equals("mdia");
    }

    @Override
    public QuickTimeHandler<?> processAtom(@NotNull Atom atom, @Nullable byte[] payload, QuickTimeContext context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals("mvhd")) {
                MovieHeaderAtom movieHeaderAtom = new MovieHeaderAtom(reader, atom);
                movieHeaderAtom.addMetadata(this.directory);
            } else if (atom.type.equals("ftyp")) {
                FileTypeCompatibilityAtom fileTypeCompatibilityAtom = new FileTypeCompatibilityAtom(reader, atom);
                fileTypeCompatibilityAtom.addMetadata(this.directory);
            } else {
                if (atom.type.equals("hdlr")) {
                    HandlerReferenceAtom handlerReferenceAtom = new HandlerReferenceAtom(reader, atom);
                    return this.handlerFactory.getHandler(handlerReferenceAtom.getComponentType(), this.metadata, context);
                }
                if (atom.type.equals("mdhd")) {
                    new MediaHeaderAtom(reader, atom, context);
                } else if (atom.type.equals("CNTH")) {
                    CanonThumbnailAtom canonThumbnailAtom = new CanonThumbnailAtom(reader);
                    canonThumbnailAtom.addMetadata(this.directory);
                } else if (atom.type.equals("XMP_")) {
                    new XmpReader().extract(payload, this.metadata, (Directory)this.directory);
                } else if (atom.type.equals("tkhd")) {
                    TrackHeaderAtom trackHeaderAtom = new TrackHeaderAtom(reader, atom);
                    trackHeaderAtom.addMetadata(this.directory);
                }
            }
        } else if (atom.type.equals("cmov")) {
            this.directory.addError("Compressed QuickTime movies not supported");
        }
        return this;
    }
}

