/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mp4;

import cn.allbs.metadata.imaging.mp4.Mp4Handler;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mp4.Mp4Context;
import cn.allbs.metadata.metadata.mp4.Mp4Directory;
import cn.allbs.metadata.metadata.mp4.Mp4HandlerFactory;
import cn.allbs.metadata.metadata.mp4.boxes.Box;
import cn.allbs.metadata.metadata.mp4.boxes.FileTypeBox;
import cn.allbs.metadata.metadata.mp4.boxes.HandlerBox;
import cn.allbs.metadata.metadata.mp4.boxes.MediaHeaderBox;
import cn.allbs.metadata.metadata.mp4.boxes.MovieHeaderBox;
import cn.allbs.metadata.metadata.mp4.boxes.TrackHeaderBox;
import cn.allbs.metadata.metadata.mp4.boxes.UserDataBox;
import cn.allbs.metadata.metadata.mp4.media.Mp4UuidBoxHandler;
import java.io.IOException;

public class Mp4BoxHandler
extends Mp4Handler<Mp4Directory> {
    private Mp4HandlerFactory handlerFactory = new Mp4HandlerFactory(this);

    public Mp4BoxHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    @NotNull
    protected Mp4Directory getDirectory() {
        return new Mp4Directory();
    }

    @Override
    public boolean shouldAcceptBox(@NotNull Box box) {
        return box.type.equals("ftyp") || box.type.equals("mvhd") || box.type.equals("hdlr") || box.type.equals("mdhd") || box.type.equals("tkhd") || box.type.equals("udta") || box.type.equals("uuid");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Box box) {
        return box.type.equals("trak") || box.type.equals("meta") || box.type.equals("moov") || box.type.equals("mdia");
    }

    @Override
    public Mp4Handler<?> processBox(@NotNull Box box, @Nullable byte[] payload, Mp4Context context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (box.type.equals("mvhd")) {
                this.processMovieHeader(reader, box);
            } else if (box.type.equals("ftyp")) {
                this.processFileType(reader, box);
            } else {
                if (box.type.equals("hdlr")) {
                    HandlerBox handlerBox = new HandlerBox(reader, box);
                    return this.handlerFactory.getHandler(handlerBox, this.metadata, context);
                }
                if (box.type.equals("mdhd")) {
                    this.processMediaHeader(reader, box, context);
                } else if (box.type.equals("tkhd")) {
                    this.processTrackHeader(reader, box);
                } else if (box.type.equals("uuid")) {
                    Mp4UuidBoxHandler userBoxHandler = new Mp4UuidBoxHandler(this.metadata);
                    userBoxHandler.processBox(box, payload, context);
                } else if (box.type.equals("udta")) {
                    this.processUserData(box, reader, payload.length);
                }
            }
        } else if (box.type.equals("cmov")) {
            this.directory.addError("Compressed MP4 movies not supported");
        }
        return this;
    }

    private void processUserData(@NotNull Box box, @NotNull SequentialReader reader, int length) throws IOException {
        new UserDataBox(reader, box, length).addMetadata(this.directory);
    }

    private void processFileType(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        FileTypeBox fileTypeBox = new FileTypeBox(reader, box);
        fileTypeBox.addMetadata(this.directory);
    }

    private void processMovieHeader(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        MovieHeaderBox movieHeaderBox = new MovieHeaderBox(reader, box);
        movieHeaderBox.addMetadata(this.directory);
    }

    private void processMediaHeader(@NotNull SequentialReader reader, @NotNull Box box, Mp4Context context) throws IOException {
        new MediaHeaderBox(reader, box, context);
    }

    private void processTrackHeader(@NotNull SequentialReader reader, @NotNull Box box) throws IOException {
        TrackHeaderBox trackHeaderBox = new TrackHeaderBox(reader, box);
        trackHeaderBox.addMetadata(this.directory);
    }
}

