/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mp4.boxes;

import cn.allbs.metadata.lang.DateUtil;
import cn.allbs.metadata.lang.Rational;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.metadata.mp4.Mp4Directory;
import cn.allbs.metadata.metadata.mp4.boxes.Box;
import cn.allbs.metadata.metadata.mp4.boxes.FullBox;
import java.io.IOException;

public class MovieHeaderBox
extends FullBox {
    protected long creationTime;
    protected long modificationTime;
    protected long timescale;
    protected long duration;
    protected int rate;
    protected int volume;
    protected int[] matrix;
    protected long nextTrackID;

    public MovieHeaderBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        if (this.version == 1) {
            this.creationTime = reader.getInt64();
            this.modificationTime = reader.getInt64();
            this.timescale = reader.getUInt32();
            this.duration = reader.getInt64();
        } else {
            this.creationTime = reader.getUInt32();
            this.modificationTime = reader.getUInt32();
            this.timescale = reader.getUInt32();
            this.duration = reader.getUInt32();
        }
        this.rate = reader.getInt32();
        this.volume = reader.getInt16();
        reader.skip(2L);
        reader.skip(8L);
        this.matrix = new int[]{reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32()};
        reader.skip(24L);
        this.nextTrackID = reader.getUInt32();
    }

    public void addMetadata(Mp4Directory directory) {
        directory.setDate(256, DateUtil.get1Jan1904EpochDate(this.creationTime));
        directory.setDate(257, DateUtil.get1Jan1904EpochDate(this.modificationTime));
        directory.setLong(259, this.duration);
        directory.setLong(258, this.timescale);
        directory.setRational(260, new Rational(this.duration, this.timescale));
        directory.setIntArray(271, this.matrix);
        double preferredRateInteger = (this.rate & 0xFFFF0000) >> 16;
        double preferredRateFraction = (double)(this.rate & 0xFFFF) / Math.pow(2.0, 4.0);
        directory.setDouble(261, preferredRateInteger + preferredRateFraction);
        double preferredVolumeInteger = (this.volume & 0xFF00) >> 8;
        double preferredVolumeFraction = (double)(this.volume & 0xFF) / Math.pow(2.0, 2.0);
        directory.setDouble(262, preferredVolumeInteger + preferredVolumeFraction);
        directory.setLong(270, this.nextTrackID);
    }
}

