/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mp4.boxes;

import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.mp4.Mp4Directory;
import cn.allbs.metadata.metadata.mp4.boxes.Box;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserDataBox
extends Box {
    private static final int LOCATION_CODE = -1451722374;
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("([+-]\\d+\\.\\d+)([+-]\\d+\\.\\d+)");
    @Nullable
    private String coordinateString;

    public UserDataBox(@NotNull SequentialReader reader, @NotNull Box box, int length) throws IOException {
        super(box);
        long size;
        while (reader.getPosition() < (long)length && (size = reader.getUInt32()) > 4L) {
            int kind = reader.getInt32();
            if (kind == -1451722374) {
                int xyzLength = reader.getUInt16();
                reader.skip(2L);
                this.coordinateString = reader.getString(xyzLength, "UTF-8");
                continue;
            }
            if (size >= 8L) {
                reader.skip(size - 8L);
                continue;
            }
            return;
        }
    }

    public void addMetadata(Mp4Directory directory) {
        Matcher matcher;
        if (this.coordinateString != null && (matcher = COORDINATE_PATTERN.matcher(this.coordinateString)).find()) {
            double latitude = Double.parseDouble(matcher.group(1));
            double longitude = Double.parseDouble(matcher.group(2));
            directory.setDouble(8193, latitude);
            directory.setDouble(8194, longitude);
        }
    }
}

