/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.pcx;

import cn.allbs.metadata.imaging.ImageProcessingException;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.pcx.PcxDirectory;

public class PcxReader {
    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        reader.setMotorolaByteOrder(false);
        PcxDirectory directory = new PcxDirectory();
        metadata.addDirectory(directory);
        try {
            int vScrSize;
            int hScrSize;
            byte identifier = reader.getInt8();
            if (identifier != 10) {
                throw new ImageProcessingException("Invalid PCX identifier byte");
            }
            directory.setInt(1, reader.getInt8());
            byte encoding = reader.getInt8();
            if (encoding != 1) {
                throw new ImageProcessingException("Invalid PCX encoding byte");
            }
            directory.setInt(2, reader.getUInt8());
            directory.setInt(3, reader.getUInt16());
            directory.setInt(4, reader.getUInt16());
            directory.setInt(5, reader.getUInt16());
            directory.setInt(6, reader.getUInt16());
            directory.setInt(7, reader.getUInt16());
            directory.setInt(8, reader.getUInt16());
            directory.setByteArray(9, reader.getBytes(48));
            reader.skip(1L);
            directory.setInt(10, reader.getUInt8());
            directory.setInt(11, reader.getUInt16());
            int paletteType = reader.getUInt16();
            if (paletteType != 0) {
                directory.setInt(12, paletteType);
            }
            if ((hScrSize = reader.getUInt16()) != 0) {
                directory.setInt(13, hScrSize);
            }
            if ((vScrSize = reader.getUInt16()) != 0) {
                directory.setInt(14, vScrSize);
            }
        }
        catch (Exception ex) {
            directory.addError("Exception reading PCX file metadata: " + ex.getMessage());
        }
    }
}

