/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.plist;

import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BplistReader {
    private static final String PLIST_DTD = "<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">";
    private static final byte[] BPLIST_HEADER = new byte[]{98, 112, 108, 105, 115, 116, 48, 48};

    public static boolean isValid(byte[] bplist) {
        if (bplist.length < BPLIST_HEADER.length) {
            return false;
        }
        boolean valid = true;
        for (int i = 0; i < BPLIST_HEADER.length; ++i) {
            if (bplist[i] == BPLIST_HEADER[i]) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static PropertyListResults parse(byte[] bplist) throws IOException {
        if (!BplistReader.isValid(bplist)) {
            throw new IllegalArgumentException("Input is not a bplist");
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        Trailer trailer = BplistReader.readTrailer(bplist);
        SequentialByteArrayReader reader = new SequentialByteArrayReader(bplist, (int)(trailer.offsetTableOffset + trailer.topObject));
        int[] offsets = new int[(int)trailer.numObjects];
        for (long i = 0L; i < trailer.numObjects; ++i) {
            if (trailer.offsetIntSize == 1) {
                offsets[(int)i] = reader.getByte();
                continue;
            }
            if (trailer.offsetIntSize != 2) continue;
            offsets[(int)i] = reader.getUInt16();
        }
        block7: for (int i = 0; i < offsets.length; ++i) {
            reader = new SequentialByteArrayReader(bplist, offsets[i]);
            byte marker = reader.getByte();
            int objectFormat = marker >> 4 & 0xF;
            switch (objectFormat) {
                case 13: {
                    BplistReader.handleDict(i, marker, reader, objects);
                    continue block7;
                }
                case 5: {
                    int charCount = marker & 0xF;
                    objects.add(i, reader.getString(charCount));
                    continue block7;
                }
                case 4: {
                    BplistReader.handleData(i, marker, reader, objects);
                    continue block7;
                }
                case 1: {
                    BplistReader.handleInt(i, marker, reader, objects);
                    continue block7;
                }
                default: {
                    throw new IOException("Un-handled objectFormat encountered");
                }
            }
        }
        return new PropertyListResults(objects, trailer);
    }

    private static void handleInt(int objectIndex, byte marker, SequentialByteArrayReader reader, ArrayList<Object> objects) throws IOException {
        int objectSize = (int)Math.pow(2.0, marker & 0xF);
        if (objectSize == 1) {
            objects.add(objectIndex, reader.getByte());
        } else if (objectSize == 2) {
            objects.add(objectIndex, reader.getUInt16());
        } else if (objectSize == 4) {
            objects.add(objectIndex, reader.getUInt32());
        } else if (objectSize == 8) {
            objects.add(objectIndex, reader.getInt64());
        }
    }

    private static void handleDict(int objectIndex, byte marker, SequentialByteArrayReader reader, ArrayList<Object> objects) throws IOException {
        int j;
        LinkedHashMap<Byte, Byte> map = new LinkedHashMap<Byte, Byte>();
        int dictEntries = marker & 0xF;
        byte[] keyRefs = new byte[dictEntries];
        for (j = 0; j < dictEntries; ++j) {
            keyRefs[j] = reader.getByte();
        }
        for (j = 0; j < dictEntries; ++j) {
            map.put(keyRefs[j], reader.getByte());
        }
        objects.add(objectIndex, map);
    }

    private static void handleData(int objectIndex, byte marker, SequentialByteArrayReader reader, ArrayList<Object> objects) throws IOException {
        int byteCount = marker & 0xF;
        if (byteCount == 15) {
            byte sizeMarker = reader.getByte();
            if ((sizeMarker >> 4 & 0xF) != 1) {
                throw new IllegalArgumentException("Invalid size marker");
            }
            int objectSizeWidth = (int)Math.pow(2.0, sizeMarker & 0xF);
            if (objectSizeWidth == 1) {
                byteCount = reader.getInt8();
            } else if (objectSizeWidth == 2) {
                byteCount = reader.getUInt16();
            }
        }
        objects.add(objectIndex, reader.getBytes(byteCount));
    }

    private static Trailer readTrailer(byte[] bplist) throws IOException {
        SequentialByteArrayReader reader = new SequentialByteArrayReader(bplist, bplist.length - 32);
        reader.skip(5L);
        reader.skip(1L);
        Trailer trailer = new Trailer();
        trailer.offsetIntSize = reader.getByte();
        trailer.objectRefSize = reader.getByte();
        trailer.numObjects = reader.getInt64();
        trailer.topObject = reader.getInt64();
        trailer.offsetTableOffset = reader.getInt64();
        return trailer;
    }

    private static class Trailer {
        public static final int STRUCT_SIZE = 32;
        byte offsetIntSize;
        byte objectRefSize;
        long numObjects;
        long topObject;
        long offsetTableOffset;

        private Trailer() {
        }
    }

    public static class PropertyListResults {
        private final List<Object> objects;
        private final Trailer trailer;

        public PropertyListResults(List<Object> objects, Trailer trailer) {
            this.objects = objects;
            this.trailer = trailer;
        }

        public List<Object> getObjects() {
            return this.objects;
        }

        public Trailer getTrailer() {
            return this.trailer;
        }

        @Nullable
        public Set<Map.Entry<Byte, Byte>> getEntrySet() {
            Object topObject = this.getObjects().get((int)this.getTrailer().topObject);
            if (topObject instanceof Map) {
                Map dict = (Map)topObject;
                return dict.entrySet();
            }
            return null;
        }

        public String toXML() {
            StringBuilder xml = new StringBuilder().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(BplistReader.PLIST_DTD).append("<plist version=\"1.0\">");
            Set<Map.Entry<Byte, Byte>> entrySet = this.getEntrySet();
            if (entrySet != null) {
                xml.append("<dict>");
                for (Map.Entry<Byte, Byte> entry : entrySet) {
                    xml.append("<key>").append((String)this.getObjects().get(entry.getKey().byteValue())).append("</key>");
                    xml.append("<integer>").append(this.getObjects().get(entry.getValue().byteValue()).toString()).append("</integer>");
                }
                xml.append("</dict>");
            }
            xml.append("</plist>");
            return xml.toString();
        }
    }
}

