/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.minio;

import cn.allbs.minio.MinioProperties;
import cn.allbs.minio.endpoint.MinioEndpoint;
import cn.allbs.minio.template.MinioTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={MinioProperties.class})
@Configuration
public class MinioAutoConfiguration {
    private final MinioProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={MinioTemplate.class})
    @ConditionalOnProperty(name={"minio.url"})
    public MinioTemplate template() {
        return new MinioTemplate(this.properties);
    }

    @Bean
    @ConditionalOnProperty(name={"minio.endpoint.enable"}, havingValue="true")
    public MinioEndpoint minioEndpoint(MinioTemplate template) {
        return new MinioEndpoint(template);
    }

    public MinioAutoConfiguration(MinioProperties properties) {
        this.properties = properties;
    }
}

