/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.minio.template;

import cn.allbs.minio.MinioProperties;
import cn.allbs.minio.model.MinioItem;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioTemplate {
    private static final Logger log = LoggerFactory.getLogger(MinioTemplate.class);
    private final MinioClient client;
    private final String BASE_BUCKET;

    public MinioTemplate(MinioProperties minioProperties) {
        this.client = MinioClient.builder().endpoint(minioProperties.getUrl(), minioProperties.getPort().intValue(), minioProperties.getSecure().booleanValue()).credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).build();
        this.BASE_BUCKET = minioProperties.getBucketName();
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            this.createBucket(this.BASE_BUCKET);
        }
        log.debug("allbs:init minio client, current configuration is " + BeanUtil.beanToMap((Object)minioProperties));
    }

    public void createBucket(String bucketName) {
        if (StrUtil.isNotEmpty((CharSequence)bucketName) && !this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
            MakeBucketArgs args = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build();
            this.client.makeBucket(args);
        }
    }

    public List<Bucket> getAllBuckets() {
        return this.client.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.client.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst();
    }

    public void removeBucket(String bucketName) {
        this.client.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public List<MinioItem> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        ArrayList<MinioItem> objectList = new ArrayList<MinioItem>();
        Iterable objectsIterator = this.client.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(recursive).build());
        for (Result itemResult : objectsIterator) {
            objectList.add(new MinioItem((Item)itemResult.get()));
        }
        return objectList;
    }

    public String getObjectURL(String bucketName, String objectName, Integer expires) {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            objectName = bucketName + "/" + objectName;
            bucketName = this.BASE_BUCKET;
        }
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(objectName)).expiry(expires.intValue()).build();
        return this.client.getPresignedObjectUrl(args);
    }

    public InputStream getObject(String bucketName, String objectName) {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            objectName = bucketName + "/" + objectName;
            bucketName = this.BASE_BUCKET;
        }
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build();
        return this.client.getObject(args);
    }

    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            objectName = bucketName + "/" + objectName;
            bucketName = this.BASE_BUCKET;
        } else {
            this.createBucket(bucketName);
        }
        PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, (long)stream.available(), -1L).contentType("application/octet-stream").sse(null)).build();
        this.client.putObject(args);
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            objectName = bucketName + "/" + objectName;
            bucketName = this.BASE_BUCKET;
        } else {
            this.createBucket(bucketName);
        }
        PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, size, -1L).contentType(contextType).sse(null)).build();
        this.client.putObject(args);
    }

    public StatObjectResponse getObjectInfo(String bucketName, String objectName) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            objectName = bucketName + "/" + objectName;
            bucketName = this.BASE_BUCKET;
        }
        StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build();
        return this.client.statObject(args);
    }

    public void removeObject(String bucketName, String objectName) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            objectName = bucketName + "/" + objectName;
            bucketName = this.BASE_BUCKET;
        }
        RemoveObjectArgs args = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build();
        this.client.removeObject(args);
    }

    public void removeObjects(String bucketName, List<String> objectNameList) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)this.BASE_BUCKET)) {
            ArrayList deleteObjectNameList = new ArrayList();
            objectNameList.forEach(a -> deleteObjectNameList.add(bucketName + "/" + a));
            List list = deleteObjectNameList.stream().map(DeleteObject::new).collect(Collectors.toList());
            RemoveObjectsArgs removeObjectsArgs = (RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(this.BASE_BUCKET)).objects(list).build();
            this.client.removeObjects(removeObjectsArgs);
            return;
        }
        List list = objectNameList.stream().map(DeleteObject::new).collect(Collectors.toList());
        RemoveObjectsArgs removeObjectsArgs = (RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(list).build();
        this.client.removeObjects(removeObjectsArgs);
    }
}

