/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.minio.endpoint;

import cn.allbs.minio.model.MinioItem;
import cn.allbs.minio.template.MinioTemplate;
import io.minio.StatObjectResponse;
import io.minio.messages.Bucket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"${minio.endpoint.name:/minio}"})
public class MinioEndpoint {
    private final MinioTemplate template;

    @PostMapping(value={"/bucket/{bucketName}"})
    public Bucket createBucket(@PathVariable String bucketName) {
        this.template.createBucket(bucketName);
        return this.template.getBucket(bucketName).get();
    }

    @GetMapping(value={"/bucket"})
    public List<Bucket> getBuckets() {
        return this.template.getAllBuckets();
    }

    @GetMapping(value={"/bucket/{bucketName}"})
    public Bucket getBucket(@PathVariable String bucketName) {
        return this.template.getBucket(bucketName).orElseThrow(() -> new IllegalArgumentException("Bucket Name not found!"));
    }

    @DeleteMapping(value={"/bucket/{bucketName}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteBucket(@PathVariable String bucketName) {
        this.template.removeBucket(bucketName);
    }

    @PostMapping(value={"/object/{bucketName}"})
    public StatObjectResponse createObject(@RequestBody MultipartFile object, @PathVariable String bucketName) {
        String name = object.getOriginalFilename();
        this.template.putObject(bucketName, name, object.getInputStream(), object.getSize(), object.getContentType());
        return this.template.getObjectInfo(bucketName, name);
    }

    @PostMapping(value={"/object/{bucketName}/{objectName}"})
    public StatObjectResponse createObject(@RequestBody MultipartFile object, @PathVariable String bucketName, @PathVariable String objectName) {
        this.template.putObject(bucketName, objectName, object.getInputStream(), object.getSize(), object.getContentType());
        return this.template.getObjectInfo(bucketName, objectName);
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}"})
    public List<MinioItem> filterObject(@PathVariable String bucketName, @PathVariable String objectName) {
        return this.template.getAllObjectsByPrefix(bucketName, objectName, true);
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}/{expires}"})
    public Map<String, Object> getObject(@PathVariable String bucketName, @PathVariable String objectName, @PathVariable Integer expires) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(8);
        responseBody.put("bucket", bucketName);
        responseBody.put("object", objectName);
        responseBody.put("url", this.template.getObjectURL(bucketName, objectName, expires));
        responseBody.put("expires", expires);
        return responseBody;
    }

    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @DeleteMapping(value={"/object/{bucketName}/{objectName}/"})
    public void deleteObject(@PathVariable String bucketName, @PathVariable String objectName) {
        this.template.removeObject(bucketName, objectName);
    }

    public MinioEndpoint(MinioTemplate template) {
        this.template = template;
    }
}

