/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.sms.client;

import cn.allbs.sms.client.AbstractClient;
import cn.allbs.sms.properties.SmsClientProperties;
import cn.allbs.sms.properties.SmsDetailProperties;
import cn.allbs.sms.util.Utils;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliYunClient
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(AliYunClient.class);

    public AliYunClient(SmsClientProperties smsClientProperties) {
        super(smsClientProperties.getAli());
    }

    @Override
    public String sendCode(String code, String ... phoneNumbers) throws Exception {
        String res = "";
        String templateId = (String)this.smsTemplateMap.keySet().iterator().next();
        SmsDetailProperties sms = (SmsDetailProperties)this.smsTemplateMap.get(templateId);
        Client client = this.buildClient(templateId);
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(Utils.join(phoneNumbers, (CharSequence)",")).setSignName(sms.getSignName()).setTemplateCode(templateId).setTemplateParam(sms.getTemplateParam().toString()).setSmsUpExtendCode(sms.getRemarks()).setOutId(sms.getExpandContent());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            SendSmsResponse response = client.sendSmsWithOptions(sendSmsRequest, runtime);
            res = response.toString();
        }
        catch (TeaException error) {
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        catch (Exception e) {
            TeaException error = new TeaException(e.getMessage(), (Throwable)e);
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        return res;
    }

    @Override
    public String sendCode(String templateId, String code, String ... phoneNumbers) throws Exception {
        String res = "";
        SmsDetailProperties sms = (SmsDetailProperties)this.smsTemplateMap.get(templateId);
        Client client = this.buildClient(templateId);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("code", code);
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(Utils.join(phoneNumbers, (CharSequence)",")).setSignName(sms.getSignName()).setTemplateCode(templateId).setTemplateParam(((Object)params).toString()).setSmsUpExtendCode(sms.getRemarks()).setOutId(sms.getExpandContent());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            SendSmsResponse response = client.sendSmsWithOptions(sendSmsRequest, runtime);
            res = response.toString();
        }
        catch (TeaException error) {
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        catch (Exception e) {
            TeaException error = new TeaException(e.getMessage(), (Throwable)e);
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        return res;
    }

    @Override
    public String send() throws Exception {
        String res = "";
        String templateId = (String)this.smsTemplateMap.keySet().iterator().next();
        SmsDetailProperties sms = (SmsDetailProperties)this.smsTemplateMap.get(templateId);
        Client client = this.buildClient(templateId);
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(Utils.join(sms.getPhoneNumbers(), (CharSequence)",")).setSignName(sms.getSignName()).setTemplateCode(templateId).setTemplateParam(sms.getTemplateParam().toString()).setSmsUpExtendCode(sms.getRemarks()).setOutId(sms.getExpandContent());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            SendSmsResponse response = client.sendSmsWithOptions(sendSmsRequest, runtime);
            res = response.toString();
        }
        catch (TeaException error) {
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        catch (Exception e) {
            TeaException error = new TeaException(e.getMessage(), (Throwable)e);
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        return res;
    }

    @Override
    public String send(String templateId, Map<String, String> params, String ... phoneNumbers) throws Exception {
        String res = "";
        SmsDetailProperties sms = (SmsDetailProperties)this.smsTemplateMap.get(templateId);
        Client client = this.buildClient(templateId);
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(Utils.join(phoneNumbers, (CharSequence)",")).setSignName(sms.getSignName()).setTemplateCode(templateId).setTemplateParam(params.toString()).setSmsUpExtendCode(sms.getRemarks()).setOutId(sms.getExpandContent());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            SendSmsResponse response = client.sendSmsWithOptions(sendSmsRequest, runtime);
            res = response.toString();
        }
        catch (TeaException error) {
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        catch (Exception e) {
            TeaException error = new TeaException(e.getMessage(), (Throwable)e);
            res = error.message;
            log.warn("allbs-sms\u544a\u8b66\u63d0\u793a{}", (Object)res);
        }
        return res;
    }

    private Client buildClient(String templateId) throws Exception {
        SmsDetailProperties sms = Optional.ofNullable(this.smsTemplateMap).map(a -> (SmsDetailProperties)a.get(templateId)).orElse(null);
        super.propertiesChange(sms);
        Config config = new Config().setAccessKeyId(this.appKey).setAccessKeySecret(this.appSecret);
        config.setEndpoint(this.endPoint);
        config.setRegionId(this.region);
        return new Client(config);
    }
}

