/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.sms.client;

import cn.allbs.sms.client.AbstractClient;
import cn.allbs.sms.properties.SmsClientProperties;
import cn.allbs.sms.properties.SmsDetailProperties;
import cn.allbs.sms.util.Utils;
import cn.hutool.core.bean.BeanUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaWeiYunClient
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(HuaWeiYunClient.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";

    public HuaWeiYunClient(SmsClientProperties smsClientProperties) {
        super(smsClientProperties.getHuawei());
    }

    @Override
    public String sendCode(String code, String ... phoneNumbers) throws Exception {
        String templateId = (String)this.smsTemplateMap.keySet().iterator().next();
        SmsDetailProperties sms = Optional.ofNullable(this.smsTemplateMap).map(a -> (SmsDetailProperties)a.get(templateId)).orElse(null);
        super.propertiesChange(sms);
        Gson gson = new Gson();
        assert (sms != null);
        String templateParas = gson.toJson(sms.getTemplateParam().values());
        String statusCallBack = "";
        String body = this.buildRequestBody(sms.getSdkAppId(), Utils.join(phoneNumbers, (CharSequence)","), templateId, templateParas, statusCallBack, sms.getSignName());
        if (null == body || body.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: body is null.");
            return null;
        }
        String wsseHeader = this.buildWsseHeader(this.appKey, this.appSecret);
        if (null == wsseHeader || wsseHeader.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: wsse header is null.");
            return null;
        }
        CloseableHttpClient client = null;
        try {
            client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            assert (client != null);
            response = client.execute(RequestBuilder.create((String)"POST").setUri(this.endPoint).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            log.info("allbs-sms \u63d0\u793a:  response is" + response.toString());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (BeanUtil.isNotEmpty((Object)entity, (String[])new String[0])) {
                Map resultMap = (Map)gson.fromJson(result, Map.class);
                log.info("allbs-sms \u63d0\u793a: the message is to be sent " + resultMap);
                if ("000000".equals(resultMap.get("code"))) {
                    log.info("allbs-sms \u63d0\u793a: \u77ed\u4fe1\u53d1\u9001\u6210\u529f,message content is" + result);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("allbs-sms \u63d0\u793a: \u77ed\u4fe1API\u8c03\u7528\u5931\u8d25\uff01");
        }
        return null;
    }

    @Override
    public String sendCode(String templateId, String code, String ... phoneNumbers) throws Exception {
        SmsDetailProperties sms = Optional.ofNullable(this.smsTemplateMap).map(a -> (SmsDetailProperties)a.get(templateId)).orElse(null);
        super.propertiesChange(sms);
        Gson gson = new Gson();
        assert (sms != null);
        String templateParas = gson.toJson(sms.getTemplateParam().values());
        String statusCallBack = "";
        String body = this.buildRequestBody(sms.getSdkAppId(), Utils.join(phoneNumbers, (CharSequence)","), templateId, templateParas, statusCallBack, sms.getSignName());
        if (null == body || body.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: body is null.");
            return null;
        }
        String wsseHeader = this.buildWsseHeader(this.appKey, this.appSecret);
        if (null == wsseHeader || wsseHeader.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: wsse header is null.");
            return null;
        }
        CloseableHttpClient client = null;
        try {
            client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            assert (client != null);
            response = client.execute(RequestBuilder.create((String)"POST").setUri(this.endPoint).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            log.info("allbs-sms \u63d0\u793a:  response is" + response.toString());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (BeanUtil.isNotEmpty((Object)entity, (String[])new String[0])) {
                Map resultMap = (Map)gson.fromJson(result, Map.class);
                log.info("allbs-sms \u63d0\u793a: the message is to be sent " + resultMap);
                if ("000000".equals(resultMap.get("code"))) {
                    log.info("allbs-sms \u63d0\u793a: \u77ed\u4fe1\u53d1\u9001\u6210\u529f,message content is" + result);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("allbs-sms \u63d0\u793a: \u77ed\u4fe1API\u8c03\u7528\u5931\u8d25\uff01");
        }
        return null;
    }

    @Override
    public String send() throws Exception {
        String templateId = (String)this.smsTemplateMap.keySet().iterator().next();
        SmsDetailProperties sms = Optional.ofNullable(this.smsTemplateMap).map(a -> (SmsDetailProperties)a.get(templateId)).orElse(null);
        super.propertiesChange(sms);
        Gson gson = new Gson();
        assert (sms != null);
        String templateParas = gson.toJson(sms.getTemplateParam().values());
        String statusCallBack = "";
        String body = this.buildRequestBody(sms.getSdkAppId(), Utils.join(sms.getPhoneNumbers(), (CharSequence)","), templateId, templateParas, statusCallBack, sms.getSignName());
        if (null == body || body.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: body is null.");
            return null;
        }
        String wsseHeader = this.buildWsseHeader(this.appKey, this.appSecret);
        if (null == wsseHeader || wsseHeader.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: wsse header is null.");
            return null;
        }
        CloseableHttpClient client = null;
        try {
            client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            assert (client != null);
            response = client.execute(RequestBuilder.create((String)"POST").setUri(this.endPoint).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            log.info("allbs-sms \u63d0\u793a:  response is" + response.toString());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (BeanUtil.isNotEmpty((Object)entity, (String[])new String[0])) {
                Map resultMap = (Map)gson.fromJson(result, Map.class);
                log.info("allbs-sms \u63d0\u793a: the message is to be sent " + resultMap);
                if ("000000".equals(resultMap.get("code"))) {
                    log.info("allbs-sms \u63d0\u793a: \u77ed\u4fe1\u53d1\u9001\u6210\u529f,message content is" + result);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("allbs-sms \u63d0\u793a: \u77ed\u4fe1API\u8c03\u7528\u5931\u8d25\uff01");
        }
        return null;
    }

    @Override
    public String send(String templateId, Map<String, String> params, String ... phoneNumbers) throws Exception {
        SmsDetailProperties sms = Optional.ofNullable(this.smsTemplateMap).map(a -> (SmsDetailProperties)a.get(templateId)).orElse(null);
        super.propertiesChange(sms);
        Gson gson = new Gson();
        assert (sms != null);
        String templateParas = gson.toJson(params.values());
        String statusCallBack = "";
        String body = this.buildRequestBody(sms.getSdkAppId(), Utils.join(phoneNumbers, (CharSequence)","), templateId, templateParas, statusCallBack, sms.getSignName());
        if (null == body || body.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: body is null.");
            return null;
        }
        String wsseHeader = this.buildWsseHeader(this.appKey, this.appSecret);
        if (null == wsseHeader || wsseHeader.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: wsse header is null.");
            return null;
        }
        CloseableHttpClient client = null;
        try {
            client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            assert (client != null);
            response = client.execute(RequestBuilder.create((String)"POST").setUri(this.endPoint).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            log.info("allbs-sms \u63d0\u793a:  response is" + response.toString());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (BeanUtil.isNotEmpty((Object)entity, (String[])new String[0])) {
                Map resultMap = (Map)gson.fromJson(result, Map.class);
                log.info("allbs-sms \u63d0\u793a: the message is to be sent " + resultMap);
                if ("000000".equals(resultMap.get("code"))) {
                    log.info("allbs-sms \u63d0\u793a: \u77ed\u4fe1\u53d1\u9001\u6210\u529f,message content is" + result);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("allbs-sms \u63d0\u793a: \u77ed\u4fe1API\u8c03\u7528\u5931\u8d25\uff01");
        }
        return null;
    }

    private String buildRequestBody(String sender, String receiver, String templateId, String templateParas, String statusCallbackUrl, String signature) {
        if (null == sender || null == receiver || null == templateId || sender.isEmpty() || receiver.isEmpty() || templateId.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: buildRequestBody sender, receiver or templateId is null.");
            return null;
        }
        ArrayList<BasicNameValuePair> keyValues = new ArrayList<BasicNameValuePair>();
        keyValues.add(new BasicNameValuePair("from", sender));
        keyValues.add(new BasicNameValuePair("to", receiver));
        keyValues.add(new BasicNameValuePair("templateId", templateId));
        if (null != templateParas && !templateParas.isEmpty()) {
            keyValues.add(new BasicNameValuePair("templateParas", templateParas));
        }
        if (null != statusCallbackUrl && !statusCallbackUrl.isEmpty()) {
            keyValues.add(new BasicNameValuePair("statusCallback", statusCallbackUrl));
        }
        if (null != signature && !signature.isEmpty()) {
            keyValues.add(new BasicNameValuePair("signature", signature));
        }
        return URLEncodedUtils.format(keyValues, (Charset)StandardCharsets.UTF_8);
    }

    private String buildWsseHeader(String appKey, String appSecret) {
        if (null == appKey || null == appSecret || appKey.isEmpty() || appSecret.isEmpty()) {
            log.error("allbs-sms \u63d0\u793a: appKey or appSecret is null in method buildWsseHeader");
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] passwordDigest = DigestUtils.sha256((String)(nonce + time + appSecret));
        String hexDigest = Hex.encodeHexString((byte[])passwordDigest);
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }
}

