/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.sms.client;

import cn.allbs.sms.client.IClient;
import cn.allbs.sms.exception.SmsException;
import cn.allbs.sms.properties.SmsDetailProperties;
import cn.allbs.sms.properties.SmsProperties;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements IClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    protected Map<String, SmsDetailProperties> smsTemplateMap;
    protected String appKey;
    protected String appSecret;
    protected String region;
    protected String endPoint;
    protected Long timeOut;

    public AbstractClient(SmsProperties smsProperties) {
        if (!Optional.ofNullable(smsProperties).isPresent() || smsProperties.getTemplates().isEmpty()) {
            throw new SmsException("\u77ed\u4fe1\u901a\u9053\u4fe1\u606f\u672a\u914d\u7f6e,\u77ed\u4fe1\u670d\u52a1\u4e0d\u53ef\u7528!");
        }
        this.smsTemplateMap = smsProperties.getTemplates();
        this.appKey = smsProperties.getAppKey();
        this.appSecret = smsProperties.getAppSecret();
        this.timeOut = smsProperties.getTimeout();
        this.region = smsProperties.getRegion();
        this.endPoint = smsProperties.getEndPoint();
    }

    @Override
    public String sendCode(String code, String ... phoneNumbers) throws Exception {
        return null;
    }

    @Override
    public String sendCode(String templateId, String code, String ... phoneNumbers) throws Exception {
        return null;
    }

    @Override
    public String send() throws Exception {
        return null;
    }

    @Override
    public String send(String templateId, Map<String, String> params, String ... phoneNumbers) throws Exception {
        return null;
    }

    public void propertiesChange(SmsDetailProperties smsDetailProperties) {
        this.appKey = Optional.ofNullable(smsDetailProperties).map(SmsDetailProperties::getAppKey).orElse(this.appKey);
        this.appSecret = Optional.ofNullable(smsDetailProperties).map(SmsDetailProperties::getAppSecret).orElse(this.appSecret);
        this.region = Optional.ofNullable(smsDetailProperties).map(SmsDetailProperties::getRegion).orElse(this.region);
        this.endPoint = Optional.ofNullable(smsDetailProperties).map(SmsDetailProperties::getEndPoint).orElse(this.endPoint);
    }
}

