package cn.allbs.swagger;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/6 下午8:32
 */
@Data
@Component
@ConfigurationProperties(prefix = "swagger")
public class SwaggerProperties {

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String description;

    /**
     * 名称
     */
    private String name;

    /**
     * url
     */
    private String url;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 版本
     */
    private String version;

    /**
     * 服务Url
     */
    private String termServiceUrl;

    /**
     * host
     */
    private String host;

    /**
     * 分组名称
     */
    private String groupName;

    /**
     * 扫描的controller
     */
    private String basePackage;
}
