/*
 * Decompiled with CFR 0.152.
 */
package cn.amorou.uid.boot;

import cn.amorou.uid.UidGenerator;
import cn.amorou.uid.boot.UidGeneratorProperties;
import cn.amorou.uid.buffer.RejectedPutBufferHandler;
import cn.amorou.uid.buffer.RejectedTakeBufferHandler;
import cn.amorou.uid.impl.CachedUidGenerator;
import cn.amorou.uid.impl.DefaultUidGenerator;
import cn.amorou.uid.worker.DisposableWorkerIdAssigner;
import cn.amorou.uid.worker.SimpleWorkerIdAssigner;
import cn.amorou.uid.worker.WorkerIdAssigner;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@EnableConfigurationProperties(value={UidGeneratorProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="uid", name={"auto"}, havingValue="true", matchIfMissing=true)
public class UidGeneratorAutoConfiguration {
    @Resource
    private ApplicationContext applicationContext;

    @Bean(name={"uidSqlSessionFactory"})
    @ConditionalOnBean(value={DataSource.class})
    public SqlSessionFactory uidSqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:/META-INF/mybatis/mapper/*.xml"));
        return bean.getObject();
    }

    @Bean
    @ConditionalOnBean(value={SqlSessionFactory.class})
    @ConditionalOnProperty(prefix="uid", name={"worker-id-assigner-impl"}, havingValue="cn.amorou.uid.worker.DisposableWorkerIdAssigner", matchIfMissing=false)
    public WorkerIdAssigner disposableWorkerIdAssigner() {
        return new DisposableWorkerIdAssigner();
    }

    @Bean
    @ConditionalOnProperty(prefix="uid", name={"worker-id-assigner-impl"}, havingValue="cn.amorou.uid.worker.SimpleWorkerIdAssigner", matchIfMissing=true)
    public WorkerIdAssigner simpleWorkerIdAssigner() {
        return new SimpleWorkerIdAssigner();
    }

    @Bean
    @ConditionalOnMissingBean(value={UidGenerator.class})
    @ConditionalOnProperty(prefix="uid", name={"uid-generator-impl"}, havingValue="cn.amorou.uid.impl.DefaultUidGenerator", matchIfMissing=true)
    public UidGenerator defaultUidGenerator(WorkerIdAssigner workerIdAssigner, UidGeneratorProperties uidGeneratorProperties) {
        DefaultUidGenerator uidGenerator = new DefaultUidGenerator();
        uidGenerator.setWorkerIdAssigner(workerIdAssigner);
        uidGenerator.setEpochStr(uidGeneratorProperties.getEpochStr());
        uidGenerator.setSeqBits(uidGeneratorProperties.getSeqBits());
        uidGenerator.setTimeBits(uidGeneratorProperties.getTimeBits());
        uidGenerator.setWorkerBits(uidGeneratorProperties.getWorkerBits());
        return uidGenerator;
    }

    @Bean
    @ConditionalOnBean(value={SqlSessionFactory.class})
    @ConditionalOnMissingBean(value={UidGenerator.class})
    @ConditionalOnProperty(prefix="uid", name={"uid-generator-impl"}, havingValue="cn.amorou.uid.impl.CachedUidGenerator", matchIfMissing=false)
    public UidGenerator cachedUidGenerator(WorkerIdAssigner workerIdAssigner, UidGeneratorProperties uidGeneratorProperties, RejectedPutBufferHandler rejectedPutBufferHandler, RejectedTakeBufferHandler rejectedTakeBufferHandler) {
        CachedUidGenerator uidGenerator = new CachedUidGenerator();
        uidGenerator.setWorkerIdAssigner(workerIdAssigner);
        if (uidGeneratorProperties.getBoostPower() > 0) {
            uidGenerator.setBoostPower(uidGeneratorProperties.getBoostPower());
        }
        if (uidGeneratorProperties.getScheduleInterval() > 0L) {
            uidGenerator.setScheduleInterval(uidGeneratorProperties.getScheduleInterval());
        }
        uidGenerator.setSeqBits(uidGeneratorProperties.getSeqBits());
        uidGenerator.setTimeBits(uidGeneratorProperties.getTimeBits());
        uidGenerator.setWorkerBits(uidGeneratorProperties.getWorkerBits());
        if (rejectedPutBufferHandler != null) {
            uidGenerator.setRejectedPutBufferHandler(rejectedPutBufferHandler);
        }
        if (rejectedTakeBufferHandler != null) {
            uidGenerator.setRejectedTakeBufferHandler(rejectedTakeBufferHandler);
        }
        return uidGenerator;
    }
}

