package cn.aotcloud.safe.autoconfigure;

import javax.servlet.MultipartConfigElement;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.MultipartAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.util.unit.DataSize;
import org.springframework.web.multipart.MultipartResolver;

import cn.aotcloud.safe.autoconfigure.jdbc.AbstractApplicationHomeUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.AbstractBinderUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.ApplicationHomeUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.BinderUtil;

@Configuration
@Import({ 
	SafeAutoConfiguration.class
})
@ConditionalOnProperty(prefix = "acloud.safe", name = "enabled", matchIfMissing = true)
@AutoConfigureAfter(MultipartAutoConfiguration.class)
public class SafeAdapterConfiguration {

	@Bean
	@Primary
	@ConditionalOnBean(MultipartResolver.class)
	public MultipartConfigElement acloudMultipartConfigElement(SafeProperties safeProperties) {
		MultipartProperties multipartProperties = new MultipartProperties();
		// 单个数据大小
		multipartProperties.setMaxFileSize(DataSize.ofBytes(safeProperties.getUpload().getMaxFileByteSize()));
		// 总上传数据大小
		multipartProperties.setMaxRequestSize(DataSize.ofBytes(safeProperties.getUpload().getMaxRequestByteSize()));
		return multipartProperties.createMultipartConfig();
	}
	
	@Bean
	public AbstractBinderUtil binderUtil() {
		return new BinderUtil();
	}
	
	@Bean
	public AbstractApplicationHomeUtil applicationHomeUtil() {
		return new ApplicationHomeUtil();
	}
	
}
