package cn.aotcloud.safe.autoconfigure.jdbc;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;

import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;

import cn.aotcloud.safe.autoconfigure.SafeProperties;

public class BinderUtil extends AbstractBinderUtil {
	
	@Override
	public void rebindSafeConfigRequestToBean(HttpServletRequest request, SafeProperties safeProperties) {
		LOGGER.info(String.format("执行来自request的对象绑定：%s", safeProperties.getClass().getName()));
		Map<String, Object> dataMap = new HashMap<String, Object>();
		Enumeration<String> names = request.getParameterNames();
		while(names.hasMoreElements()) {
			String name = names.nextElement();
			String value= request.getParameter(name);
			String envKey = AbstractBinderUtil.SAFE_PROP_PREFIX + name;
			dataMap.put(envKey, value);
        }
		ConfigurationPropertySource sources = new MapConfigurationPropertySource(dataMap);
        Binder binder = new Binder(sources);
        binder.bind("acloud.safe", Bindable.ofInstance(safeProperties.getClass())).get(); 
	}
	
	@Override
	public void rebindSafeConfigEntrysToBean(List<SafeConfigItemEntry> entryList, SafeProperties safeProperties) {
		Map<String, Object> dataMap = new HashMap<String, Object>();
		LOGGER.info(String.format("执行来自数据库的对象绑定：%s", safeProperties.getClass().getName()));
		entryList.forEach(entry-> {
			String envKey = AbstractBinderUtil.SAFE_PROP_PREFIX + (entry.getPropKey());
			dataMap.put(envKey, entry.getPropValue());
        });
		ConfigurationPropertySource sources = new MapConfigurationPropertySource(dataMap);
        Binder binder = new Binder(sources);
        binder.bind("acloud.safe", Bindable.ofInstance(safeProperties)).get(); 
	}
	
	@Override
	public void resetMultipartConfigElement(MultipartConfigElement multipartConfigElement, SafeProperties safeProperties) {
		try {
			Field maxFileSizeField = multipartConfigElement.getClass().getDeclaredField("maxFileSize");
			maxFileSizeField.setAccessible(true);
			maxFileSizeField.setLong(multipartConfigElement, safeProperties.getUpload().getMaxFileByteSize());
			Field maxRequestSizeField = multipartConfigElement.getClass().getDeclaredField("maxRequestSize");
			maxRequestSizeField.setAccessible(true);
			maxRequestSizeField.setLong(multipartConfigElement, safeProperties.getUpload().getMaxRequestByteSize());
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}
	
}
