/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.autoconfigure;

import cn.aotcloud.safe.autoconfigure.SafeAutoConfiguration;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.autoconfigure.jdbc.AbstractApplicationHomeUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.AbstractBinderUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.ApplicationHomeUtil;
import cn.aotcloud.safe.autoconfigure.jdbc.BinderUtil;
import javax.servlet.MultipartConfigElement;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.MultipartAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.util.unit.DataSize;
import org.springframework.web.multipart.MultipartResolver;

@Configuration
@Import(value={SafeAutoConfiguration.class})
@ConditionalOnProperty(prefix="acloud.safe", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={MultipartAutoConfiguration.class})
public class SafeAdapterConfiguration {
    @Bean
    @Primary
    @ConditionalOnBean(value={MultipartResolver.class})
    public MultipartConfigElement acloudMultipartConfigElement(SafeProperties safeProperties) {
        MultipartProperties multipartProperties = new MultipartProperties();
        multipartProperties.setMaxFileSize(DataSize.ofBytes((long)safeProperties.getUpload().getMaxFileByteSize()));
        multipartProperties.setMaxRequestSize(DataSize.ofBytes((long)safeProperties.getUpload().getMaxRequestByteSize()));
        return multipartProperties.createMultipartConfig();
    }

    @Bean
    public AbstractBinderUtil binderUtil() {
        return new BinderUtil();
    }

    @Bean
    public AbstractApplicationHomeUtil applicationHomeUtil() {
        return new ApplicationHomeUtil();
    }
}

