/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.audit;

import cn.aotcloud.safe.audit.AuditLog;
import cn.aotcloud.safe.audit.AuditService;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.limiter.II11iIiI;
import com.alibaba.fastjson.JSON;
import java.util.Map;

public class AuditHandle {
    private SafeProperties safeProperties;
    private AuditService auditService;
    private II11iIiI safeLimiterHandle;

    public AuditHandle(SafeProperties safeProperties, AuditService auditService, II11iIiI safeLimiterHandle) {
        this.safeProperties = safeProperties;
        this.auditService = safeProperties.getAudit().isEnabled() ? auditService : null;
        this.safeLimiterHandle = safeLimiterHandle;
    }

    public void sendAudit(String requestUri, String contentType, int contentLength, String httpMethod, String remoteAddr, Map<String, String> headers, Map<String, String> parameters, int errorCode, String errorMessage, String description) {
        if (this.safeProperties.getLimit().isEnabled()) {
            this.safeLimiterHandle.i111IiI1(remoteAddr);
        }
        if (this.auditService != null) {
            AuditLog auditLog = new AuditLog();
            auditLog.setRequestUri(requestUri);
            auditLog.setContentType(contentType);
            auditLog.setContentLength(contentLength);
            auditLog.setHttpMethod(httpMethod);
            auditLog.setRemoteAddr(remoteAddr);
            auditLog.setHost(headers.get("host"));
            auditLog.setReferer(headers.get("referer"));
            auditLog.setOrigin(headers.get("origin"));
            auditLog.setHeaders(JSON.toJSONString(headers));
            auditLog.setParameters(JSON.toJSONString(parameters));
            auditLog.setDescription(description);
            auditLog.setErrorCode(errorCode);
            auditLog.setErrorMessage(errorMessage);
            this.auditService.audit(auditLog);
        }
    }
}

