/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.audit;

import java.util.ArrayList;
import java.util.List;

public class AuditLogPage<T> {
    private List<T> datas = new ArrayList<T>(0);
    private boolean hasPreviousPage;
    private boolean hasNextPage;
    private int totalCount;
    private int totalPageCount;
    private int currentPage = 1;
    private int pageSize = 5;
    private Enum<Sort> sort;

    public void gotoPreviousPage() {
        if (this.isHasPreviousPage()) {
            --this.currentPage;
        }
    }

    public void gotoNextPage() {
        if (this.isHasNextPage()) {
            ++this.currentPage;
        }
    }

    public void gotoFirstPage() {
        this.currentPage = 1;
    }

    public void gotoLastPage() {
        this.currentPage = this.totalPageCount;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public boolean isHasPreviousPage() {
        this.hasPreviousPage = this.currentPage > 1;
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public boolean isHasNextPage() {
        this.hasNextPage = this.currentPage < this.getTotalPageCount();
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getTotalPageCount() {
        this.totalPageCount = this.totalCount % this.pageSize == 0 ? this.totalCount / this.pageSize : this.totalCount / this.pageSize + 1;
        return this.totalPageCount;
    }

    public void setTotalPageCount(int totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public int getCurrentPage() {
        if (this.currentPage > this.getTotalPageCount()) {
            this.currentPage = this.getTotalPageCount();
        }
        return this.currentPage <= 0 ? 1 : this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Enum<Sort> getSort() {
        return this.sort;
    }

    public void setSort(Enum<Sort> sort) {
        this.sort = sort;
    }

    public boolean getHasPreviousPage() {
        this.hasPreviousPage = this.currentPage > 1;
        return this.hasPreviousPage;
    }

    public boolean getHasNextPage() {
        this.hasNextPage = this.currentPage < this.getTotalPageCount();
        return this.hasNextPage;
    }

    public static enum Sort {
        ASC,
        DESC;

    }
}

