/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.audit;

import cn.aotcloud.safe.audit.AuditLog;
import cn.aotcloud.safe.audit.AuditService;
import cn.aotcloud.safe.audit.AuditServiceDao;
import cn.aotcloud.safe.autoconfigure.I11iiiiI;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.autoconfigure.ii1II111;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AuditServiceAbstract
implements AuditService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected SafeProperties safeProperties;
    protected ApplicationContext applicationContext;
    protected Object receiveObject;
    protected Method receiveMethod;

    public AuditServiceAbstract(ApplicationContext applicationContext, SafeProperties safeProperties, AuditServiceDao auditServiceDao) {
        this.applicationContext = applicationContext;
        this.safeProperties = safeProperties;
        this.initReceiveMethod();
    }

    public void initReceiveMethod() {
        String string = this.safeProperties.getAudit().getReceiveMethod();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String string2 = StringUtils.substringBeforeLast((String)string, (String)".");
            String string3 = StringUtils.substringAfterLast((String)string, (String)".");
            Class<?> clazz = null;
            try {
                clazz = this.getClass().getClassLoader().loadClass(string2);
                if (clazz != null) {
                    this.receiveObject = this.applicationContext.getBean(clazz);
                    this.receiveMethod = ReflectionUtils.findMethod(this.receiveObject.getClass(), (String)string3, (Class[])new Class[]{String.class});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.LOGGER.error("\u5ba1\u8ba1\u65e5\u5fd7\u5199\u5165\u65b9\u6cd5\u521d\u59cb\u5316\u5f02\u5e38:{}", (Object)classNotFoundException.getMessage());
            }
        }
    }

    public void sendRemoteAuditLog(AuditLog auditLog) {
        try {
            String string;
            JSONObject jSONObject = (JSONObject)JSONObject.toJSON((Object)auditLog);
            if (jSONObject.containsKey((Object)"headers")) {
                string = jSONObject.getString("headers");
                jSONObject.put("headers", (Object)JSON.parseObject((String)string));
            }
            if (jSONObject.containsKey((Object)"parameters")) {
                string = jSONObject.getString("parameters");
                jSONObject.put("parameters", (Object)JSON.parseObject((String)string));
            }
            if (auditLog.getErrorCode() != ii1II111.I1IiiI1I.I111ii1I() && StringUtils.isNotBlank((CharSequence)(string = I11iiiiI.II11iIiI(auditLog.getErrorCode())))) {
                jSONObject.put("errorMessage", (Object)String.format("\u8bf7\u6c42\u8d44\u6e90%s\u65f6\u5b58\u5728%s\u60c5\u51b5\uff1a%s", auditLog.getRequestUri(), string, auditLog.getErrorMessage()));
            }
            if ((string = RequestContextHolder.getRequestAttributes()) != null) {
                jSONObject.put("sessionId", (Object)string.getSessionId());
            }
            String string2 = jSONObject.toJSONString();
            ReflectionUtils.invokeMethod((Method)this.receiveMethod, (Object)this.receiveObject, (Object[])new Object[]{string2});
        }
        catch (Exception exception) {
            this.LOGGER.error("\u5ba1\u8ba1\u65e5\u5fd7\u5199\u5165\u5f02\u5e38:{}", (Object)exception.getMessage());
        }
    }
}

