/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.audit;

import cn.aotcloud.safe.audit.AuditLog;
import cn.aotcloud.safe.audit.AuditProperties;
import cn.aotcloud.safe.audit.AuditServiceAbstract;
import cn.aotcloud.safe.audit.AuditServiceDao;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@EnableScheduling
public class AuditServiceBatchImp
extends AuditServiceAbstract {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private AuditServiceDao auditServiceDao;
    private BlockingQueue<AuditLog> DATA_QUEUE = new LinkedBlockingQueue<AuditLog>(5000);
    private int batchSize = 100;

    public AuditServiceBatchImp(ApplicationContext applicationContext, SafeProperties safeProperties, AuditServiceDao auditServiceDao) {
        super(applicationContext, safeProperties, auditServiceDao);
        this.auditServiceDao = auditServiceDao;
        this.batchSize = safeProperties.getAudit().getBatchSize();
        this.DATA_QUEUE = new LinkedBlockingQueue<AuditLog>(safeProperties.getAudit().getQueueSize());
    }

    @Override
    public void audit(AuditLog auditLog) {
        this.LOGGER.debug("\u5ba1\u8ba1\u65e5\u5fd7\uff1a\n{  RequestUrl:" + auditLog.getRequestUri() + "\n  ContentType:" + auditLog.getContentType() + "\n   HttpMethod:" + auditLog.getHttpMethod() + "\n   RemoteAddr:" + auditLog.getRemoteAddr() + "\n        Hosts:" + auditLog.getHost() + "\n      Referer:" + auditLog.getReferer() + "\n       Origin:" + auditLog.getOrigin() + "\n   getHeaders:" + auditLog.getHeaders() + "\n ParameterMap:" + auditLog.getParameters() + "\n  Description:" + auditLog.getDescription() + "\n    errorCode:" + auditLog.getErrorCode() + "\n errorMessage:" + auditLog.getErrorMessage() + "}\n ");
        if (this.receiveMethod != null && auditLog != null) {
            this.sendRemoteAuditLog(auditLog);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.safeProperties.getAudit().getType().getValue(), (CharSequence[])new CharSequence[]{AuditProperties.AuditType.DATASOURCE.getValue(), AuditProperties.AuditType.SQLITE.getValue()})) {
            try {
                this.DATA_QUEUE.put(auditLog);
                if (this.DATA_QUEUE.size() > this.batchSize) {
                    this.insertQueue();
                }
            }
            catch (InterruptedException interruptedException) {
                this.LOGGER.debug("\u5ba1\u8ba1\u65e5\u5fd7\u5199\u5165\u4e34\u65f6\u961f\u5217\u5f02\u5e38:" + interruptedException.getMessage());
            }
        }
    }

    @Scheduled(cron="0/10 * * * * ?")
    public void insertQueue() {
        int n = 0;
        ArrayList<AuditLog> arrayList = new ArrayList<AuditLog>();
        AuditLog auditLog = null;
        boolean bl = false;
        for (int i = 0; i < this.batchSize; ++i) {
            if (Thread.interrupted()) continue;
            auditLog = (AuditLog)this.DATA_QUEUE.poll();
            if (auditLog != null) {
                arrayList.add(auditLog);
                continue;
            }
            bl = true;
            break;
        }
        if (bl && !arrayList.isEmpty()) {
            n = this.auditServiceDao.insertAuditLogBatch(arrayList);
            arrayList.clear();
        }
        this.LOGGER.debug("\u5ba1\u8ba1\u65e5\u5fd7\u5b9a\u65f6\u5199\u5165\u6570\u636e\u5e93{}\u6761\u8bb0\u5f55", (Object)n);
    }
}

