/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.audit;

import cn.aotcloud.safe.audit.AuditLog;
import cn.aotcloud.safe.audit.AuditServiceDao;
import cn.aotcloud.safe.autoconfigure.I11iiiiI;
import cn.aotcloud.safe.codecs.I11iiiIi;
import cn.aotcloud.safe.limiter.II11iIiI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/safeConf/audit"})
public class AuditServiceController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final char[] IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
    private I11iiiIi htmlCodec = new I11iiiIi();
    private AuditServiceDao auditServiceDao;
    private II11iIiI safeLimiterHandle;

    public AuditServiceController() {
        this.auditServiceDao = null;
    }

    public AuditServiceController(AuditServiceDao auditServiceDao, II11iIiI safeLimiterHandle) {
        this.auditServiceDao = auditServiceDao;
        this.safeLimiterHandle = safeLimiterHandle;
    }

    @RequestMapping(value={"/", ""}, method={RequestMethod.POST, RequestMethod.GET})
    public void console(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.auditServiceDao != null) {
            response.sendRedirect(request.getContextPath() + "/safeConf" + "/auditList.html");
        } else {
            response.sendRedirect(request.getContextPath() + "/safeConf" + "/auditError.html");
        }
    }

    @RequestMapping(value={"/getErrorCodes"})
    @ResponseBody
    public Map<String, String> getErrorCodes() {
        List<String> list = this.auditServiceDao.getErrorCodes();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        list.forEach(item -> hashMap.put((String)item, I11iiiiI.II11iIiI(NumberUtils.toInt((String)item, (int)-1))));
        return hashMap;
    }

    @RequestMapping(value={"/getPage"})
    @ResponseBody
    public Map<String, Object> getAllByBeginNumber(HttpServletRequest request) {
        int n = 10;
        int n2 = 1;
        if (request.getParameter("pageSize") != null) {
            n = NumberUtils.toInt((String)request.getParameter("pageSize").toString(), (int)10);
        }
        if (request.getParameter("pageNumber") != null) {
            n2 = NumberUtils.toInt((String)request.getParameter("pageNumber").toString(), (int)1);
        }
        if (n2 <= 1) {
            n2 = 1;
        }
        String string = request.getParameter("sortName");
        String string2 = request.getParameter("sortOrder");
        String string3 = request.getParameter("errorMessage");
        String string4 = request.getParameter("errorCode");
        this.LOGGER.debug(String.format("\u5ba1\u8ba1\u65e5\u5fd7\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageNumber=%d,pageSize=%d,sortName=%s,sortOrder=%s,errorMessage=%s,errorCode=%s", n2, n, string, string2, string3, string4));
        List<AuditLog> list = this.auditServiceDao.getPage(n, n2, string, string2, string3, string4);
        list.forEach(item -> {
            item.setParameters(this.htmlCodec.encode(IMMUNE_HTML, item.getParameters()));
            item.setErrorMessage(this.htmlCodec.encode(IMMUNE_HTML, item.getErrorMessage()));
        });
        int n3 = this.auditServiceDao.getCount(string3, string4);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("rows", list);
        hashMap.put("total", n3);
        return hashMap;
    }

    @RequestMapping(value={"/statis"})
    @ResponseBody
    public List<Map<String, Object>> statis(HttpServletRequest request) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> list = this.auditServiceDao.statis();
        list.forEach(item -> {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", I11iiiiI.II11iIiI(NumberUtils.toInt((String)String.valueOf(item.get("error_code")), (int)-1)));
            hashMap.put("value", NumberUtils.toInt((String)String.valueOf(item.get("total")), (int)0));
            arrayList.add(hashMap);
        });
        return arrayList;
    }

    @RequestMapping(value={"/gethostAttackTop10"})
    @ResponseBody
    public Map<String, Object> gethostAttackTop10(HttpServletRequest request) {
        List<Map<String, Object>> list = this.auditServiceDao.gethostAttackTop10();
        List list2 = list.stream().map(item -> String.valueOf(item.get("host"))).collect(Collectors.toList());
        List list3 = list.stream().map(item -> String.valueOf(item.get("total"))).collect(Collectors.toList());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("host", list2);
        hashMap.put("total", list3);
        return hashMap;
    }

    @RequestMapping(value={"/getAttackSourceTop10"})
    @ResponseBody
    public Map<String, Object> getAttackSourceTop10(HttpServletRequest request) {
        List<Map<String, Object>> list = this.auditServiceDao.getAttackSourceTop10();
        List list2 = list.stream().map(item -> String.valueOf(item.get("remote_addr"))).collect(Collectors.toList());
        List list3 = list.stream().map(item -> String.valueOf(item.get("total"))).collect(Collectors.toList());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("remote_addr", list2);
        hashMap.put("total", list3);
        return hashMap;
    }

    @RequestMapping(value={"/getLockdRemoteAddr"})
    @ResponseBody
    public Map<String, Long> getLockdRemoteAddr(HttpServletRequest request) {
        return this.safeLimiterHandle.I111ii1I().asMap();
    }
}

