/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.audit;

import cn.aotcloud.safe.audit.AuditLog;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.autoconfigure.jdbc.AbstractApplicationHomeUtil;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.util.ClassUtils;

public class AuditServiceDao {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String AUDIT_LOG_TABLE_NAME_BASE = "safe_audit_log";
    private String SAFE_CONFIG_SCHEMA = "sql/audit_log_mysql.sql";
    private String audit_log_table_name = this.AUDIT_LOG_TABLE_NAME_BASE;
    private JdbcTemplate jdbcTemplate;

    public AuditServiceDao(AbstractApplicationHomeUtil applicationHomeUtil, SafeProperties safeProperties) {
        File file = applicationHomeUtil.getSource();
        String string = "safelog.db";
        string = file.getPath().endsWith("classes") ? file.getPath() + File.separator + string : file.getPath().replace(".jar", "_safelog.db");
        if (safeProperties != null && safeProperties.getAudit() != null && StringUtils.isNotBlank((CharSequence)safeProperties.getAudit().getTablePrefix())) {
            this.audit_log_table_name = safeProperties.getAudit().getTablePrefix() + "_" + this.AUDIT_LOG_TABLE_NAME_BASE;
        }
        this.SAFE_CONFIG_SCHEMA = "sql/audit_log_sqlite.sql";
        this.LOGGER.info("Sqlite\u6570\u636e\u5e93\u6587\u4ef6\u8def\u5f84:" + string);
        SimpleDriverDataSource simpleDriverDataSource = new SimpleDriverDataSource();
        simpleDriverDataSource.setUrl("jdbc:sqlite:" + string);
        simpleDriverDataSource.setUsername("safelog");
        simpleDriverDataSource.setPassword("safelog");
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)"org.sqlite.JDBC", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (LinkageError linkageError) {
            linkageError.printStackTrace();
        }
        simpleDriverDataSource.setDriverClass(clazz);
        Map<String, String> map = this.getDatabaseProduct((DataSource)simpleDriverDataSource);
        this.LOGGER.info(String.format("\u6570\u636e\u5e93\u4ea7\u54c1\u4fe1\u606f\uff1a%s %s", map.get("databaseProductName"), map.get("databaseProductVersion")));
        this.LOGGER.info(String.format("\u6570\u636e\u5e93\u9a71\u52a8\u4fe1\u606f\uff1a%s %s", map.get("driverName"), map.get("driverVersion")));
        this.initSafeConfigTable((DataSource)simpleDriverDataSource);
        try {
            ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
            comboPooledDataSource.setUser("safelog");
            comboPooledDataSource.setPassword("safelog");
            comboPooledDataSource.setJdbcUrl("jdbc:sqlite:" + string);
            comboPooledDataSource.setDriverClass("org.sqlite.JDBC");
            comboPooledDataSource.setInitialPoolSize(10);
            comboPooledDataSource.setMinPoolSize(10);
            comboPooledDataSource.setMaxPoolSize(20);
            this.jdbcTemplate = new JdbcTemplate((DataSource)comboPooledDataSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AuditServiceDao(DataSource dataSource, SafeProperties safeProperties) {
        if (safeProperties != null && safeProperties.getAudit() != null && StringUtils.isNotBlank((CharSequence)safeProperties.getAudit().getTablePrefix())) {
            this.audit_log_table_name = safeProperties.getAudit().getTablePrefix() + "_" + this.AUDIT_LOG_TABLE_NAME_BASE;
        }
        this.jdbcTemplate = this.getJdbcTemplate(dataSource);
        Map<String, String> map = this.getDatabaseProduct(dataSource);
        this.LOGGER.info(String.format("\u6570\u636e\u5e93\u4ea7\u54c1\u4fe1\u606f\uff1a%s %s", map.get("databaseProductName"), map.get("databaseProductVersion")));
        this.LOGGER.info(String.format("\u6570\u636e\u5e93\u9a71\u52a8\u4fe1\u606f\uff1a%s %s", map.get("driverName"), map.get("driverVersion")));
        if (StringUtils.indexOfIgnoreCase((CharSequence)map.get("databaseProductName"), (CharSequence)"oracle") != -1) {
            this.SAFE_CONFIG_SCHEMA = "sql/audit_log_oracle.sql";
        } else if (StringUtils.indexOfIgnoreCase((CharSequence)map.get("databaseProductName"), (CharSequence)"mysql") != -1) {
            this.SAFE_CONFIG_SCHEMA = "sql/audit_log_mysql.sql";
        } else {
            throw new IllegalStateException("\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\u5f00\u542f\u5b89\u5168\u62e6\u622a\u65e5\u5fd7\u8bb0\u5f55");
        }
        this.initSafeConfigTable(dataSource);
    }

    private JdbcTemplate getJdbcTemplate(DataSource dataSource) {
        if (dataSource != null) {
            return new JdbcTemplate(dataSource);
        }
        throw new IllegalStateException("JdbcTemplate\u521d\u59cb\u5316\u5931\u8d25");
    }

    public void initSafeConfigTable(DataSource dataSource) {
        boolean bl = this.hasSafeConfigTable(dataSource);
        if (!bl) {
            bl = this.createSafeConfigTable(dataSource);
            this.LOGGER.info(String.format("\u5b89\u5168\u62e6\u622a\u65e5\u5fd7\u8868%s\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u8868%s", this.audit_log_table_name, bl ? "\u6210\u529f" : "\u5931\u8d25"));
        } else {
            this.LOGGER.info(String.format("\u5b89\u5168\u62e6\u622a\u65e5\u5fd7\u8868%s\u5df2\u5b58\u5728", this.audit_log_table_name));
        }
    }

    public boolean insertAuditLog(final AuditLog auditLog) {
        String string = "INSERT INTO " + this.audit_log_table_name + "(id,request_uri,content_type,content_length,http_method,remote_addr,host,referer,origin,headers,parameters,error_code,error_message,description,create_time) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        int n = 0;
        try {
            n = this.jdbcTemplate.update(string, new PreparedStatementSetter(){

                public void setValues(PreparedStatement preparedStatement) throws SQLException {
                    preparedStatement.setString(1, AuditServiceDao.getUUID());
                    preparedStatement.setString(2, auditLog.getRequestUri());
                    preparedStatement.setString(3, auditLog.getContentType());
                    preparedStatement.setInt(4, auditLog.getContentLength());
                    preparedStatement.setString(5, auditLog.getHttpMethod());
                    preparedStatement.setString(6, auditLog.getRemoteAddr());
                    preparedStatement.setString(7, auditLog.getHost());
                    preparedStatement.setString(8, auditLog.getReferer());
                    preparedStatement.setString(9, auditLog.getOrigin());
                    preparedStatement.setString(10, auditLog.getHeaders());
                    preparedStatement.setString(11, auditLog.getParameters());
                    preparedStatement.setInt(12, auditLog.getErrorCode());
                    preparedStatement.setString(13, auditLog.getErrorMessage());
                    preparedStatement.setString(14, auditLog.getDescription());
                    preparedStatement.setTimestamp(15, new Timestamp(System.currentTimeMillis()));
                }
            });
        }
        catch (Exception exception) {
            this.LOGGER.info(String.format("\u5b89\u5168\u62e6\u622a\u65e5\u5fd7\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff1a%s", exception.getMessage()));
        }
        return n > 0;
    }

    public int insertAuditLogBatch(final List<AuditLog> auditLogList) {
        String string = "INSERT INTO " + this.audit_log_table_name + "(id,request_uri,content_type,content_length,http_method,remote_addr,host,referer,origin,headers,parameters,error_code,error_message,description,create_time) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        int n = 0;
        int[] nArray = new int[]{};
        try {
            nArray = this.jdbcTemplate.batchUpdate(string, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return auditLogList.size();
                }

                public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
                    AuditLog auditLog = (AuditLog)auditLogList.get(i);
                    preparedStatement.setString(1, AuditServiceDao.getUUID());
                    preparedStatement.setString(2, auditLog.getRequestUri());
                    preparedStatement.setString(3, auditLog.getContentType());
                    preparedStatement.setInt(4, auditLog.getContentLength());
                    preparedStatement.setString(5, auditLog.getHttpMethod());
                    preparedStatement.setString(6, auditLog.getRemoteAddr());
                    preparedStatement.setString(7, auditLog.getHost());
                    preparedStatement.setString(8, auditLog.getReferer());
                    preparedStatement.setString(9, auditLog.getOrigin());
                    preparedStatement.setString(10, auditLog.getHeaders());
                    preparedStatement.setString(11, auditLog.getParameters());
                    preparedStatement.setInt(12, auditLog.getErrorCode());
                    preparedStatement.setString(13, auditLog.getErrorMessage());
                    preparedStatement.setString(14, auditLog.getDescription());
                    preparedStatement.setTimestamp(15, new Timestamp(System.currentTimeMillis()));
                }
            });
        }
        catch (Exception exception) {
            this.LOGGER.info(String.format("\u5b89\u5168\u62e6\u622a\u65e5\u5fd7\u6279\u91cf\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff1a%s", exception.getMessage()));
        }
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    public List<String> getErrorCodes() {
        String string = "SELECT s.error_code FROM " + this.audit_log_table_name + " s GROUP BY s.error_code";
        List list = this.jdbcTemplate.query(string, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        });
        return list;
    }

    public int getCount(String errorMessage, String errorCode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(*) from " + this.audit_log_table_name + " ");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorMessage}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorCode})) {
            stringBuffer.append(" where ");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorMessage})) {
                stringBuffer.append(" error_message like ?");
                arrayList.add("%" + errorMessage + "%");
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorCode})) {
                stringBuffer.append(" error_code = ?");
                arrayList.add(errorCode);
            }
        }
        int n = (Integer)this.jdbcTemplate.queryForObject(stringBuffer.toString(), arrayList.toArray(new Object[arrayList.size()]), Integer.class);
        return n;
    }

    public List<AuditLog> getPage(int pageSize, int beginNumber, String sortName, String sortOrder, String errorMessage, String errorCode) {
        int n = (beginNumber - 1) * pageSize;
        int n2 = pageSize;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from " + this.audit_log_table_name + " ");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorMessage}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorCode})) {
            stringBuffer.append(" where ");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorMessage})) {
                stringBuffer.append(" error_message like ?");
                arrayList.add("%" + errorMessage + "%");
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorCode})) {
                stringBuffer.append(" error_code = ?");
                arrayList.add(errorCode);
            }
        }
        sortName = StringUtils.isBlank((CharSequence)sortName) || !Pattern.compile("^[a-zA-z0-9_]+$").matcher(sortName).find() ? "create_time" : AuditServiceDao.humpToLine(sortName);
        sortOrder = StringUtils.equalsIgnoreCase((CharSequence)sortOrder, (CharSequence)"asc") ? "asc" : "desc";
        stringBuffer.append(" order by " + sortName + " " + sortOrder + " limit ?,?");
        arrayList.add(n);
        arrayList.add(n2);
        List list = this.jdbcTemplate.query(stringBuffer.toString(), arrayList.toArray(new Object[arrayList.size()]), (RowMapper)new BeanPropertyRowMapper(AuditLog.class));
        return list;
    }

    public List<Map<String, Object>> statis() {
        String string = "SELECT error_code,COUNT(id) AS total FROM " + this.audit_log_table_name + " GROUP BY error_code ORDER BY error_code";
        List list = this.jdbcTemplate.queryForList(string);
        return list;
    }

    public List<Map<String, Object>> gethostAttackTop10() {
        String string = "SELECT * FROM (SELECT * FROM (SELECT s.host,COUNT(*) AS total FROM " + this.audit_log_table_name + " s WHERE s.error_code=10101 GROUP BY s.host ORDER BY total DESC) t LIMIT 0,10) X ORDER BY x.total DESC";
        List list = this.jdbcTemplate.queryForList(string);
        return list;
    }

    public List<Map<String, Object>> getAttackSourceTop10() {
        String string = "SELECT * FROM (SELECT * FROM (SELECT s.remote_addr,COUNT(*) AS total FROM " + this.audit_log_table_name + " s GROUP BY s.remote_addr ORDER BY total DESC) t LIMIT 0,10) X ORDER BY x.total DESC";
        List list = this.jdbcTemplate.queryForList(string);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDatabaseProduct(DataSource dataSource) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            hashMap.put("databaseProductName", databaseMetaData.getDatabaseProductName());
            hashMap.put("databaseProductVersion", databaseMetaData.getDatabaseProductVersion());
            hashMap.put("driverName", databaseMetaData.getDriverName());
            hashMap.put("driverVersion", databaseMetaData.getDriverVersion());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSafeConfigTable(DataSource dataSource) {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            resultSet = databaseMetaData.getTables(null, null, this.audit_log_table_name, stringArray);
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSafeConfigTable(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(this.SAFE_CONFIG_SCHEMA);
            String[] stringArray = StringUtils.split((String)IOUtils.toString((InputStream)inputStream, (String)"UTF-8"), (String)";");
            Arrays.asList(stringArray).forEach(item -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item})) {
                    try {
                        item = item.replace(this.AUDIT_LOG_TABLE_NAME_BASE, this.audit_log_table_name);
                        jdbcTemplate.execute(item);
                    }
                    catch (Exception exception) {
                        this.LOGGER.error(String.format("SQL\u6267\u884c\u5f02\u5e38\uff1a%s", item));
                    }
                }
            });
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            this.LOGGER.error(String.format("\u65e0\u6cd5\u52a0\u8f7d%s\u6587\u4ef6", this.SAFE_CONFIG_SCHEMA), (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String getUUID() {
        String string = UUID.randomUUID().toString();
        return string.replaceAll("-", "");
    }

    public static String humpToLine(String str) {
        Matcher matcher = Pattern.compile("[A-Z]").matcher(str);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "_" + matcher.group(0).toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().toLowerCase();
    }

    public static String lineToHump(String str) {
        Matcher matcher = Pattern.compile("_(\\w)").matcher(str);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

