/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.autoconfigure;

import cn.aotcloud.safe.audit.AuditService;
import cn.aotcloud.safe.audit.AuditServiceBatchImp;
import cn.aotcloud.safe.audit.AuditServiceController;
import cn.aotcloud.safe.audit.AuditServiceDao;
import cn.aotcloud.safe.audit.AuditServiceSignImp;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.autoconfigure.jdbc.AbstractApplicationHomeUtil;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DataSource.class})
@ConditionalOnProperty(prefix="acloud.safe.audit", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class II11iIiI {
    @Bean
    @ConditionalOnProperty(prefix="acloud.safe.audit", name={"type"}, havingValue="datasource", matchIfMissing=false)
    public AuditServiceDao auditServiceDaoOnBean(DataSource dataSource, SafeProperties safeProperties) {
        return new AuditServiceDao(dataSource, safeProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="acloud.safe.audit", name={"type"}, havingValue="sqlite", matchIfMissing=false)
    public AuditServiceDao auditServiceDaoOnMissingBean(AbstractApplicationHomeUtil applicationHomeUtil, SafeProperties safeProperties) {
        return new AuditServiceDao(applicationHomeUtil, safeProperties);
    }

    @Bean
    @ConditionalOnBean(value={AuditServiceDao.class})
    @ConditionalOnProperty(prefix="acloud.safe.audit", name={"batch-enabled"}, havingValue="true", matchIfMissing=true)
    public AuditService auditServiceBatchImp(ApplicationContext applicationContext, SafeProperties safeProperties, AuditServiceDao auditServiceDao) {
        return new AuditServiceBatchImp(applicationContext, safeProperties, auditServiceDao);
    }

    @Bean
    @ConditionalOnBean(value={AuditServiceDao.class})
    @ConditionalOnProperty(prefix="acloud.safe.audit", name={"batch-enabled"}, havingValue="false", matchIfMissing=false)
    public AuditService auditServiceSignImp(ApplicationContext applicationContext, SafeProperties safeProperties, AuditServiceDao auditServiceDao) {
        return new AuditServiceSignImp(applicationContext, safeProperties, auditServiceDao);
    }

    @Bean
    @ConditionalOnBean(value={AuditServiceDao.class})
    public AuditServiceController auditServiceControllerOnBean(AuditServiceDao auditServiceDao, cn.aotcloud.safe.limiter.II11iIiI safeLimiterHandle) {
        return new AuditServiceController(auditServiceDao, safeLimiterHandle);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuditServiceDao.class})
    public AuditServiceController auditServiceControllerOnMissingBean() {
        return new AuditServiceController();
    }
}

