/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import cn.aotcloud.safe.II11iIiI;
import cn.aotcloud.safe.II11iIiI.i1iI111I;
import cn.aotcloud.safe.audit.AuditProperties;
import cn.aotcloud.safe.autoconfigure.SafeProperties;
import cn.aotcloud.safe.autoconfigure.jdbc.i111IiI1;
import cn.aotcloud.safe.codecs.Codec;
import cn.aotcloud.safe.media.I111ii1I;
import cn.aotcloud.safe.support.download.DownloadProperties;
import cn.aotcloud.safe.support.http.HttpRequestHeaderChecker;
import cn.aotcloud.safe.support.http.cross.CrossOriginProperties;
import cn.aotcloud.safe.support.http.crypto.CryptoProperties;
import cn.aotcloud.safe.support.http.header.HttpRequestHeaderProperties;
import cn.aotcloud.safe.support.http.host.HostProperties;
import cn.aotcloud.safe.support.http.method.HttpMethodProperties;
import cn.aotcloud.safe.support.http.request.HttpRequestProperties;
import cn.aotcloud.safe.support.http.response.ResponseHeaderPropertes;
import cn.aotcloud.safe.support.http.scheme.HttpSchemeProperties;
import cn.aotcloud.safe.support.replay.ReplayProperties;
import cn.aotcloud.safe.support.sql.SqlProperties;
import cn.aotcloud.safe.support.tamperproof.TamperProofProperties;
import cn.aotcloud.safe.support.upload.UploadProperties;
import cn.aotcloud.safe.support.xss.XssProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/safeConf/logger"})
public class LoggerController {
    private final SafeProperties safeProperties;
    private final List<String> packageList = Stream.of(II11iIiI.class, AuditProperties.class, SafeProperties.class, i111IiI1.class, Codec.class, i1iI111I.class, I111ii1I.class, cn.aotcloud.safe.support.II11iIiI.class, DownloadProperties.class, HttpRequestHeaderChecker.class, CrossOriginProperties.class, CryptoProperties.class, HttpRequestHeaderProperties.class, HostProperties.class, HttpMethodProperties.class, HttpRequestProperties.class, ResponseHeaderPropertes.class, HttpSchemeProperties.class, ReplayProperties.class, SqlProperties.class, TamperProofProperties.class, UploadProperties.class, XssProperties.class).map(clazz -> clazz.getPackage().getName()).collect(Collectors.toList());
    private final String[] packageArray = this.packageList.toArray(new String[this.packageList.size()]);

    public LoggerController(SafeProperties safeProperties) {
        this.safeProperties = safeProperties;
    }

    @RequestMapping(value={"/", ""}, method={RequestMethod.POST, RequestMethod.GET})
    public void index(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.safeProperties.isLoggerLevel()) {
            response.sendRedirect(request.getContextPath() + "/safeConf" + "/loggerLevel.html");
        } else {
            response.sendRedirect(request.getContextPath() + "/safeConf" + "/loggerError.html");
        }
    }

    @GetMapping(value={"/list"})
    @ResponseBody
    public List<Map<String, Object>> getLoggerList(String level) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = logger.getLoggerContext();
        List list = loggerContext.getLoggerList();
        for (Logger logger2 : list) {
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)logger2.getName(), (CharSequence[])this.packageArray)) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", logger2.getName());
            hashMap.put("level", logger2.getEffectiveLevel().levelStr);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    @PostMapping(value={"/saveLevel"})
    @ResponseBody
    public String saveLevel(String name, String level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)level, (CharSequence[])"ALL,TRACE,DEBUG,INFO,WARN,ERROR,OFF".split(","))) {
            Logger logger = loggerContext.getLogger(name);
            if (logger != null) {
                logger.setLevel(Level.toLevel((String)level));
            }
            return "success";
        }
        return "error";
    }
}

