/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.support.http.scheme;

import cn.aotcloud.safe.annotation.PropertiesField;
import cn.aotcloud.safe.annotation.SafeHttpScheme;
import cn.aotcloud.safe.autoconfigure.ii1II111;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.StringUtils;

public class HttpSchemeProperties {
    private static final List<HttpScheme> DEFAULT_ALLOWED = new ArrayList<HttpScheme>(Arrays.asList(HttpScheme.HTTP, HttpScheme.HTTPS));
    @PropertiesField(value="\u542f\u7528")
    private boolean enabled = false;
    @PropertiesField(value="\u8fc7\u6ee4\u5668\u987a\u5e8f")
    @Min(value=0L)
    @Max(value=65536L)
    private @Min(value=0L) @Max(value=65536L) int order = 10;
    @PropertiesField(value="\u9519\u8bef\u7801")
    private int errorCode = ii1II111.II11iIiI.I111ii1I();
    @SafeHttpScheme(allowEmpty=true, values={HttpScheme.HTTP, HttpScheme.HTTPS, HttpScheme.WS, HttpScheme.WSS})
    @PropertiesField(value="\u5141\u8bb8\u4f7f\u7528\u7684HTTP\u8bf7\u6c42\u534f\u8bae\uff1aHTTP\u3001HTTPS")
    private List<HttpScheme> allowed = new ArrayList<HttpScheme>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public List<HttpScheme> getAllowed() {
        return this.allowed;
    }

    public void setAllowed(List<HttpScheme> allowed) {
        this.allowed = allowed == null || allowed.isEmpty() ? DEFAULT_ALLOWED : allowed;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enabled\uff08\u542f\u7528\uff09\uff1a" + this.isEnabled() + System.lineSeparator());
        stringBuffer.append("order\uff08\u8fc7\u6ee4\u5668\u987a\u5e8f\uff09\uff1a" + this.getOrder() + System.lineSeparator());
        stringBuffer.append("errorCode\uff08\u9519\u8bef\u7801\uff09\uff1a" + this.getErrorCode() + System.lineSeparator());
        stringBuffer.append("allowed\uff08\u5141\u8bb8\u534f\u8bae\uff09\uff1a" + StringUtils.join(this.getAllowed(), (String)",") + System.lineSeparator());
        return stringBuffer.toString();
    }

    public static enum HttpScheme {
        HTTP("HTTP"),
        HTTPS("HTTPS"),
        WS("WS"),
        WSS("WSS");

        private String value;

        private HttpScheme(String value) {
            this.value = value;
        }

        public String setValue(String value) {
            this.value = value;
            return this.value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

