/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.support.replay;

import cn.aotcloud.safe.annotation.PropertiesField;
import cn.aotcloud.safe.autoconfigure.ii1II111;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ReplayProperties
implements InitializingBean,
ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplayProperties.class);
    @PropertiesField(value="\u542f\u7528")
    private boolean enabled = false;
    @PropertiesField(value="\u8fc7\u6ee4\u5668\u987a\u5e8f")
    @Min(value=0L)
    @Max(value=65536L)
    private @Min(value=0L) @Max(value=65536L) int order = 90;
    @PropertiesField(value="\u9519\u8bef\u7801")
    private final int errorCode = ii1II111.I11iiiiI.I111ii1I();
    @PropertiesField(value="\u81ea\u5b9a\u4e49\u9632\u91cd\u653e\u7684URL\u5730\u5740")
    private List<String> urls = new ArrayList<String>();
    @PropertiesField(value="\u81ea\u5b9a\u4e49\u9632\u91cd\u653e\u7684URL\u914d\u7f6e\u6587\u4ef6")
    private List<String> files = new ArrayList<String>();
    @PropertiesField(value="\u5b9a\u65f6\u626b\u63cf")
    private Schedule schedule = new Schedule();
    private ResourceLoader resourceLoader;
    @PropertiesField(value="\u65f6\u95f4\u95f4\u9694")
    private int timeintervalSeconds = 60;
    private boolean replyOnPost = true;

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        List list = this.files.stream().map(arg_0 -> ((ResourceLoader)this.resourceLoader).getResource(arg_0)).flatMap(ReplayProperties::getlines).collect(Collectors.toList());
        list.addAll(this.urls);
        this.urls = list.stream().distinct().collect(Collectors.toList());
    }

    private static Stream<String> getlines(Resource resource) {
        try {
            return Files.readAllLines(Paths.get(resource.getFile().getAbsolutePath(), new String[0]), StandardCharsets.UTF_8).stream();
        }
        catch (IOException iOException) {
            LOGGER.error("\u52a0\u8f7d\u9632\u91cd\u653e\u6587\u4ef6\u5931\u8d25:" + resource.getFilename(), (Throwable)iOException);
            return Stream.empty();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public int getTimeintervalSeconds() {
        return this.timeintervalSeconds;
    }

    public void setTimeintervalSeconds(int timeintervalSeconds) {
        this.timeintervalSeconds = timeintervalSeconds;
    }

    public boolean isReplyOnPost() {
        return this.replyOnPost;
    }

    public void setReplyOnPost(boolean replyOnPost) {
        this.replyOnPost = replyOnPost;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enabled\uff08\u542f\u7528\uff09\uff1a" + this.isEnabled() + System.lineSeparator());
        stringBuffer.append("order\uff08\u8fc7\u6ee4\u5668\u987a\u5e8f\uff09\uff1a" + this.getOrder() + System.lineSeparator());
        stringBuffer.append("errorCode\uff08\u9519\u8bef\u7801\uff09\uff1a" + this.getErrorCode() + System.lineSeparator());
        stringBuffer.append("urls\uff08\u81ea\u5b9a\u4e49\u9632\u91cd\u653e\u7684URL\u5730\u5740\uff09\uff1a" + System.lineSeparator());
        for (String string : this.getUrls()) {
            stringBuffer.append("\t" + string + System.lineSeparator());
        }
        stringBuffer.append("files\uff08\u81ea\u5b9a\u4e49\u9632\u91cd\u653e\u7684URL\u914d\u7f6e\u6587\u4ef6\uff09\uff1a" + System.lineSeparator());
        for (String string : this.getFiles()) {
            stringBuffer.append("\t" + string + System.lineSeparator());
        }
        stringBuffer.append("schedule\uff08\u5b9a\u65f6\u626b\u63cf\u542f\u7528\uff09\uff1a" + this.getSchedule().isEnabled() + System.lineSeparator());
        stringBuffer.append("timeintervalSeconds\uff08\u65f6\u95f4\u95f4\u9694\uff09\uff1a" + this.getTimeintervalSeconds() + System.lineSeparator());
        return stringBuffer.toString();
    }

    public static class Schedule {
        @PropertiesField(value="\u542f\u7528")
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

