/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.safe.support.upload;

import cn.aotcloud.safe.annotation.PropertiesField;
import cn.aotcloud.safe.autoconfigure.ii1II111;
import cn.aotcloud.safe.i111IiI1.iiIII11I;
import cn.aotcloud.safe.support.upload.UploadCustomerProperties;
import cn.aotcloud.safe.support.upload.clamav.ClamavProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UploadProperties {
    private static final Set<String> DEFAULT_SUPPORT_WHITELIST = new HashSet<String>();
    public static final Long DEFAULT_SIZE = 0x100000L;
    public static final Pattern FILE_NAME_RAGEX = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
    @PropertiesField(value="\u542f\u7528")
    private boolean enabled = false;
    @PropertiesField(value="\u8fc7\u6ee4\u5668\u987a\u5e8f")
    @Min(value=0L)
    @Max(value=65536L)
    private @Min(value=0L) @Max(value=65536L) int order = 200;
    @PropertiesField(value="\u9519\u8bef\u7801")
    private int errorCode = ii1II111.ii1iI1Ii.I111ii1I();
    @PropertiesField(value="\u6587\u4ef6\u4e0a\u4f20\u540e\u7f00\u767d\u540d\u5355")
    private String allowed = StringUtils.join(DEFAULT_SUPPORT_WHITELIST, (String)"|");
    @PropertiesField(value="\u62e6\u622aURI\u4e0b\u4fe1\u4efb\u7684\u6587\u4ef6\u7c7b\u578b")
    private String trust = null;
    @PropertiesField(value="\u4e0a\u4f20\u5355\u6587\u4ef6\u5927\u5c0f")
    private String maxFileSize = DEFAULT_SIZE / 0x100000L + "MB";
    private Long maxFileByteSize = 10L;
    @PropertiesField(value="\u4e0a\u4f20\u8bf7\u6c42\u5927\u5c0f")
    private String maxRequestSize = DEFAULT_SIZE * 10L / 0x100000L + "MB";
    @PropertiesField(value="\u81ea\u5b9a\u4e49\u4e0a\u4f20URI\u5217\u8868")
    private List<UploadCustomerProperties> customer = new ArrayList<UploadCustomerProperties>();
    @PropertiesField(value="\u6587\u4ef6\u4e0a\u4f20\u75c5\u6bd2\u626b\u63cf\u914d\u7f6e")
    private ClamavProperties clamav = new ClamavProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getAllowed() {
        return this.allowed;
    }

    public void setAllowed(String allowed) {
        this.allowed = allowed;
    }

    public String getTrust() {
        return this.trust;
    }

    public void setTrust(String trust) {
        this.trust = trust;
    }

    public String getMaxFileSize() {
        return iiIII11I.II11iIiI(this.maxFileSize, DEFAULT_SIZE) / 0x100000L + "MB";
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Long getMaxFileByteSize() {
        this.maxFileByteSize = iiIII11I.II11iIiI(this.getMaxFileSize(), DEFAULT_SIZE);
        return this.maxFileByteSize;
    }

    public void setMaxFileByteSize(Long maxFileByteSize) {
        this.maxFileByteSize = iiIII11I.II11iIiI(this.getMaxFileSize(), DEFAULT_SIZE);
    }

    public String getMaxRequestSize() {
        return iiIII11I.II11iIiI(this.maxRequestSize, DEFAULT_SIZE * 10L) / 0x100000L + "MB";
    }

    public Long getMaxRequestByteSize() {
        return iiIII11I.II11iIiI(this.getMaxRequestSize(), DEFAULT_SIZE);
    }

    public void setMaxRequestSize(String maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public List<UploadCustomerProperties> getCustomer() {
        return this.customer;
    }

    public void setCustomer(List<UploadCustomerProperties> customer) {
        ArrayList<UploadCustomerProperties> arrayList = null;
        if (customer != null) {
            arrayList = new ArrayList<UploadCustomerProperties>();
            for (int i = 0; i < customer.size(); ++i) {
                UploadCustomerProperties uploadCustomerProperties = customer.get(i);
                if (uploadCustomerProperties == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uploadCustomerProperties.getUri()}) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uploadCustomerProperties.getAllowed()})) continue;
                arrayList.add(uploadCustomerProperties);
            }
        }
        this.customer.clear();
        this.customer.addAll(arrayList);
    }

    public ClamavProperties getClamav() {
        return this.clamav;
    }

    public void setClamav(ClamavProperties clamav) {
        this.clamav = clamav;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enabled\uff08\u542f\u7528\uff09\uff1a" + this.isEnabled() + System.lineSeparator());
        stringBuffer.append("order\uff08\u8fc7\u6ee4\u5668\u987a\u5e8f\uff09\uff1a" + this.getOrder() + System.lineSeparator());
        stringBuffer.append("errorCode\uff08\u9519\u8bef\u7801\uff09\uff1a" + this.getErrorCode() + System.lineSeparator());
        stringBuffer.append("allowed\uff08\u81ea\u5b9a\u4e49\u6587\u4ef6\u4e0a\u4f20\u540e\u7f00\u767d\u540d\u5355\uff09\uff1a" + StringUtils.join((Object[])new String[]{this.getAllowed(), "|"}) + System.lineSeparator());
        stringBuffer.append("maxFileSize\uff08\u81ea\u5b9a\u4e49\u4e0a\u4f20\u5355\u6587\u4ef6\u5927\u5c0f\uff09\uff1a" + this.getMaxFileSize() + System.lineSeparator());
        stringBuffer.append("maxRequestSize\uff08\u81ea\u5b9a\u4e49\u4e0a\u4f20\u8bf7\u6c42\u5927\u5c0f\uff09\uff1a" + this.getMaxRequestSize() + System.lineSeparator());
        stringBuffer.append("customer\uff08\u81ea\u5b9a\u4e49\u4e0a\u4f20URI\u5217\u8868\uff09\uff1a" + System.lineSeparator());
        for (UploadCustomerProperties uploadCustomerProperties : this.getCustomer()) {
            stringBuffer.append("\t" + uploadCustomerProperties.getUri() + "\uff1a" + uploadCustomerProperties.getAllowed() + System.lineSeparator());
        }
        stringBuffer.append("clamav\uff08\u6587\u4ef6\u4e0a\u4f20\u75c5\u6bd2\u626b\u63cf\u914d\u7f6e\uff09\uff1a" + System.lineSeparator());
        stringBuffer.append("\tenabled\uff08\u542f\u7528\uff09\uff1a" + this.getClamav().isEnabled() + System.lineSeparator());
        stringBuffer.append("\taddress\uff08\u6740\u6bd2\u5f15\u64ce\u5730\u5740\uff09\uff1a" + this.getClamav().getAddress() + System.lineSeparator());
        stringBuffer.append("\ttimeout\uff08\u6740\u6bd2\u8d85\u65f6\u65f6\u95f4\uff09\uff1a" + this.getClamav().getTimeout() + System.lineSeparator());
        return stringBuffer.toString();
    }

    static {
        CollectionUtils.addAll(DEFAULT_SUPPORT_WHITELIST, (Object[])StringUtils.split((String)"PDF|CEB|PPT|PPTX|XLS|XLSX|DOC|DOCX|VSD|VSDX|MPP|MPT|RTF|WPS|ET|DPS|CSV", (String)"|"));
        CollectionUtils.addAll(DEFAULT_SUPPORT_WHITELIST, (Object[])StringUtils.split((String)"RAR|ZIP|7Z|TAR|GZ|BZ2|XZ|CPIO|TAR.GZ|TAR.BZ2|TAR.XZ|TAR.7Z|TAR.Z|CHM|ISO", (String)"|"));
        CollectionUtils.addAll(DEFAULT_SUPPORT_WHITELIST, (Object[])StringUtils.split((String)"BMP|PNG|JPG|JPEG|ICO|GIF", (String)"|"));
        CollectionUtils.addAll(DEFAULT_SUPPORT_WHITELIST, (Object[])StringUtils.split((String)"MP2|MP3|WMA|WAV|MPGA|MLA|RAM|MID|MIDI|MP4|AVI|RM|RMVB|WMV|MOV|MPG|MPEG|3GP|ASF|ASX", (String)"|"));
        CollectionUtils.addAll(DEFAULT_SUPPORT_WHITELIST, (Object[])StringUtils.split((String)"YML|PROPERTIES", (String)"|"));
        CollectionUtils.addAll(DEFAULT_SUPPORT_WHITELIST, (Object[])StringUtils.split((String)"TXT|TIF|APK", (String)"|"));
    }
}

