DROP TABLE IF EXISTS `safe_config_item`;

CREATE TABLE `safe_config_item` (
  `ID` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键ID',
  `PROFILE` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '环境域',
  `PROP_DOMAIN` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '属性域',
  `PROP_KEY` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '属性键',
  `PROP_VALUE` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '属性值',
  `UPDATE_TIME` timestamp(6) NULL DEFAULT NULL COMMENT '修改时间',
  `VERSION` bigint(20) NULL DEFAULT NULL COMMENT '属性版本',
  `DESCRIPTION` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '属性描述',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `PROP_UK` (`PROP_DOMAIN`,`PROP_KEY`,`VERSION`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='配置数据';

DROP TABLE IF EXISTS `safe_config_version`;

CREATE TABLE `safe_config_version` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键ID',
  `version` bigint(20) DEFAULT NULL COMMENT '版本号',
  `create_time` timestamp(6) NULL DEFAULT NULL COMMENT '创建时间',
  `description` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '版本描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='配置版本';
