DROP TABLE "SAFE_CONFIG_ITEM";

CREATE TABLE "SAFE_CONFIG_ITEM" (	
	"ID" VARCHAR2(32), 
	"PROFILE" VARCHAR2(128), 
	"PROP_DOMAIN" VARCHAR2(128), 
	"PROP_KEY" VARCHAR2(128), 
	"PROP_VALUE" VARCHAR2(1024), 
	"UPDATE_TIME" TIMESTAMP (6), 
	"VERSION" NUMBER(*,0), 
	"DESCRIPTION" VARCHAR2(256)
);

COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."ID" IS '主键ID';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."PROFILE" IS '环境域';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."PROP_DOMAIN" IS '属性域';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."PROP_KEY" IS '属性键';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."PROP_VALUE" IS '属性值';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."VERSION" IS '属性版本';
COMMENT ON COLUMN "SAFE_CONFIG_ITEM"."DESCRIPTION" IS '属性描述';

CREATE UNIQUE INDEX "ID" ON "SAFE_CONFIG_ITEM" ("ID");
CREATE UNIQUE INDEX "PROP_UK" ON "SAFE_CONFIG_ITEM" ("PROP_DOMAIN", "PROP_KEY", "VERSION") ;
ALTER TABLE "SAFE_CONFIG_ITEM" ADD CONSTRAINT "PROP_UK" UNIQUE ("PROP_DOMAIN", "PROP_KEY", "VERSION") USING INDEX  ENABLE;
ALTER TABLE "SAFE_CONFIG_ITEM" ADD CONSTRAINT "ID" PRIMARY KEY ("ID") USING INDEX  ENABLE;

DROP TABLE "SAFE_CONFIG_VERSION";

CREATE TABLE "SAFE_CONFIG_VERSION" (	
	"ID" VARCHAR2(32), 
	"VERSION" NUMBER(*,0), 
	"CREATE_TIME" TIMESTAMP (6), 
	"DESCRIPTION" VARCHAR2(256)
);

COMMENT ON COLUMN "SAFE_CONFIG_VERSION"."ID" IS '主键ID';
COMMENT ON COLUMN "SAFE_CONFIG_VERSION"."VERSION" IS '版本号';
COMMENT ON COLUMN "SAFE_CONFIG_VERSION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SAFE_CONFIG_VERSION"."DESCRIPTION" IS '版本描述';

CREATE UNIQUE INDEX "SAFE_CONFIG_VERSION_PK" ON "SAFE_CONFIG_VERSION" ("ID") ;
ALTER TABLE "SAFE_CONFIG_VERSION" ADD CONSTRAINT "SAFE_CONFIG_VERSION_PK" PRIMARY KEY ("ID") USING INDEX  ENABLE;
