/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support;

import cn.aotcloud.exception.BaseExceptionEmpty;
import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.security.oncetoken.IllegalRequestTokenException;
import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenHandler;
import cn.aotcloud.security.oncetoken.RequestTokenParser;
import cn.aotcloud.security.oncetoken.RequestTokenStore;
import cn.aotcloud.security.oncetoken.RequestTokenValidator;
import cn.aotcloud.security.oncetoken.event.IllegalRequestTokenApplicationEvent;
import cn.aotcloud.security.oncetoken.support.DelegateRequestTokenParser;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class DefaultRequestTokenHandler
implements RequestTokenHandler,
ApplicationEventPublisherAware {
    private RequestTokenStore requestTokenStore;
    private ApplicationEventPublisher applicationEventPublisher;
    private RequestTokenParser requestTokenParser;
    private RequestTokenValidator requestTokenValidator;
    private List<OnceProtocol> supportedProtocols;

    public DefaultRequestTokenHandler(RequestTokenStore requestTokenStore, RequestTokenValidator requestTokenValidator) {
        this.requestTokenStore = requestTokenStore;
        this.requestTokenValidator = requestTokenValidator;
        this.requestTokenParser = new DelegateRequestTokenParser(this.supportedProtocols);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void validate(HttpServletRequest request) throws IllegalRequestTokenException {
        RequestToken requestTokenFromRequest = this.parseRequestToken(request);
        try {
            this.requestTokenValidator.validate(requestTokenFromRequest);
            this.requestTokenStore.save(requestTokenFromRequest);
        }
        catch (IllegalRequestTokenException e) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new IllegalRequestTokenApplicationEvent(requestTokenFromRequest != null ? requestTokenFromRequest : RequestToken.ILLEGAL_REQUEST_TOKEN));
            throw new BaseExceptionEmpty(ExceptionUtil.getMessage((Throwable)((Object)e)));
        }
    }

    protected RequestToken parseRequestToken(HttpServletRequest request) {
        return this.requestTokenParser.parse(request);
    }
}

