/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support;

import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenStore;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@EnableScheduling
public class SimpleRequestTokenStore
implements RequestTokenStore {
    private ConcurrentMap<String, RequestToken> map = new ConcurrentHashMap<String, RequestToken>();

    @Override
    public RequestToken getToken(String tokenFromRequest) {
        return (RequestToken)this.map.get(tokenFromRequest);
    }

    @Override
    public void save(RequestToken requestToken) {
        this.map.put(requestToken.getToken(), requestToken);
    }

    @Override
    public void remove(String requestToken) {
        this.map.remove(requestToken);
    }

    @Override
    @Scheduled(fixedDelay=30000L)
    public void clear() {
        if (!this.map.isEmpty()) {
            ArrayList removedToken = new ArrayList();
            this.map.forEach((key, value) -> {
                if (value.isExpired()) {
                    removedToken.add(key);
                }
            });
            if (!removedToken.isEmpty()) {
                removedToken.forEach(key -> this.map.remove(key));
            }
        }
    }
}

