/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support.simple;

import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenParser;
import cn.aotcloud.security.oncetoken.RequestTokenUtil;
import cn.aotcloud.utils.HttpServletUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.util.NumberUtils;

public class HeaderRequestTokenParser
implements RequestTokenParser {
    private static final String TOKEN_HEADER_NAME = "X-Request-Token";
    private static final String TIME_HEADER_NAME = "X-Request-Time";
    private static final String SIGN_HEADER_NAME = "X-Request-Sign";

    @Override
    public RequestToken parse(HttpServletRequest request) {
        RequestToken requestToken = this.getRequestTokenV1(request);
        return RequestTokenUtil.isValidRequestToken(requestToken) ? requestToken : null;
    }

    protected RequestToken getRequestTokenV1(HttpServletRequest request) {
        RequestToken requestToken = new RequestToken();
        String createTime = HttpServletUtil.getHeader((HttpServletRequest)request, (String)TIME_HEADER_NAME);
        if (StringUtils.isNotBlank((CharSequence)createTime)) {
            requestToken.setCreateTime((Long)NumberUtils.parseNumber((String)createTime, Long.class));
        }
        requestToken.setSign(StringEscapeUtils.escapeHtml4((String)HttpServletUtil.getHeader((HttpServletRequest)request, (String)SIGN_HEADER_NAME)));
        requestToken.setToken(StringEscapeUtils.escapeHtml4((String)HttpServletUtil.getHeader((HttpServletRequest)request, (String)TOKEN_HEADER_NAME)));
        return requestToken;
    }
}

