/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support.simple;

import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenParser;
import cn.aotcloud.security.oncetoken.RequestTokenUtil;
import cn.aotcloud.utils.HttpRequestUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.util.NumberUtils;

public class ParameterRequestTokenParser
implements RequestTokenParser {
    private static final String TOKEN_PARAM_NAME = OnceProtocol.TOKEN_PARAM_NAME;
    private static final String TIME_PARAM_NAME = OnceProtocol.TIME_PARAM_NAME;
    private static final String SIGN_PARAM_NAME = OnceProtocol.SIGN_PARAM_NAME;

    @Override
    public RequestToken parse(HttpServletRequest request) {
        RequestToken requestToken = this.getRequestTokenV1(request);
        return RequestTokenUtil.isValidRequestToken(requestToken) ? requestToken : null;
    }

    protected RequestToken getRequestTokenV1(HttpServletRequest request) {
        RequestToken requestToken = new RequestToken();
        String createTime = HttpRequestUtil.getParameterValue((HttpServletRequest)request, (String)TIME_PARAM_NAME);
        if (StringUtils.isNotBlank((CharSequence)createTime)) {
            requestToken.setCreateTime((Long)NumberUtils.parseNumber((String)createTime, Long.class));
        }
        requestToken.setSign(StringEscapeUtils.escapeHtml4((String)HttpRequestUtil.getParameterValue((HttpServletRequest)request, (String)SIGN_PARAM_NAME)));
        requestToken.setToken(StringEscapeUtils.escapeHtml4((String)HttpRequestUtil.getParameterValue((HttpServletRequest)request, (String)TOKEN_PARAM_NAME)));
        return requestToken;
    }
}

