/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.tamperproofing.impl;

import cn.aotcloud.security.tamperproofing.SafeException;
import cn.aotcloud.security.tamperproofing.impl.GetQueryTamperProofingChecker;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public abstract class PostBodyTamperProofingChecker
extends GetQueryTamperProofingChecker {
    protected final MappingJackson2HttpMessageConverter jackson2HttpMessageConverter;

    public PostBodyTamperProofingChecker(TextEncryptor textEncryptor, MappingJackson2HttpMessageConverter jackson2HttpMessageConverter) {
        super(textEncryptor);
        this.jackson2HttpMessageConverter = jackson2HttpMessageConverter;
    }

    @Override
    public boolean support(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)request.getContentType()) && HttpMethod.resolve((String)request.getMethod()) == HttpMethod.POST && this.supportInternal(request) && !super.isRootRequest(request);
    }

    @Override
    public void check(HttpServletRequest request) throws SafeException {
        String data = this.getBodyAndQueryAsJson(request);
        this.doValdiate(request, data, this.getSignValue(request));
    }

    protected abstract boolean supportInternal(HttpServletRequest var1);

    protected abstract Object getBody(HttpServletRequest var1) throws IOException, ServletException;

    protected String getBodyAndQueryAsJson(HttpServletRequest request) {
        try {
            Object body = this.getBody(request);
            LinkedHashMap<String, Object> bodyAndQuery = new LinkedHashMap<String, Object>();
            if (body != null) {
                bodyAndQuery.put("body", body);
            }
            if (StringUtils.isNotBlank((CharSequence)HttpServletUtil.getQueryString((HttpServletRequest)request))) {
                String query = this.sortQueryString(request);
                bodyAndQuery.put("query", query);
            }
            if (bodyAndQuery.isEmpty()) {
                return null;
            }
            return this.jackson2HttpMessageConverter.getObjectMapper().writeValueAsString(this.convertData(bodyAndQuery));
        }
        catch (IOException | ServletException e) {
            this.logger.error(e);
            throw new SafeException("\u9632\u7be1\u6539\u5f02\u5e38\uff1a\u7cfb\u7edf\u9519\u8bef\u3002");
        }
    }

    public Object convertData(Object value) {
        if (value instanceof Map) {
            Map json2 = (Map)value;
            LinkedHashMap data = new LinkedHashMap();
            ArrayList keys = new ArrayList(json2.keySet());
            Collections.sort(keys);
            keys.forEach(key -> data.put(key, this.convertData(json2.get(key))));
            return data;
        }
        if (value instanceof List) {
            List array = (List)value;
            ArrayList list = new ArrayList();
            array.forEach(json -> list.add(this.convertData(json)));
            return list;
        }
        return value;
    }
}

