/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.tamperproofing.utils;

import cn.aotcloud.security.tamperproofing.utils.ServletBufferInputStream;
import cn.aotcloud.security.tamperproofing.utils.ServletUtils;
import cn.aotcloud.utils.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;

public class SafeHttpRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> paramValuesMap = new HashMap<String, String[]>();
    private byte[] buffer = null;

    public SafeHttpRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        String method = request.getMethod();
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"GET")) {
            this.paramValuesMap.putAll(request.getParameterMap());
            this.copyInputStream();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"POST") && ServletUtils.isXwwwFormUrlencoded((HttpServletRequest)this)) {
            this.paramValuesMap.putAll(request.getParameterMap());
            this.copyInputStream();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"POST") && !ServletUtils.isXwwwFormUrlencoded((HttpServletRequest)this) && !ServletUtils.isMultipartFormData((HttpServletRequest)this)) {
            this.paramValuesMap.putAll(request.getParameterMap());
            this.copyInputStream();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"POST") && ServletUtils.isMultipartFormData((HttpServletRequest)this)) {
            this.copyInputStream();
        }
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public Enumeration<String> getParameterNames() {
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.paramValuesMap.get(name);
    }

    public void setParameterValues(String name, String[] values) {
        this.paramValuesMap.put(name, values);
    }

    public void removeParameter(String name) {
        this.paramValuesMap.remove(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramValuesMap;
    }

    public String getParameter(String name) {
        if (this.paramValuesMap.get(name) == null) {
            return null;
        }
        return this.paramValuesMap.get(name)[0];
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.buffer != null) {
            return new ServletBufferInputStream(this.buffer);
        }
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), ServletUtils.readCharacterEncoding((HttpServletRequest)this)));
    }

    public void copyInputStream() throws IOException {
        ServletInputStream is = null;
        try {
            is = super.getInputStream();
            if (is != null) {
                this.buffer = IOUtils.toByteArray((InputStream)is);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

