/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.CipherMode;
import cn.aotcloud.smcrypto.II11iIiI;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSignDataException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import cn.aotcloud.smcrypto.i111IiI1;
import cn.aotcloud.smcrypto.util.ByteUtils;
import cn.aotcloud.smcrypto.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class Sm2Utils {
    private CipherMode cipherMode = CipherMode.C1C2C3;
    private String randomKeyHex = null;
    private static final List<Integer> keyHexLenList = Arrays.asList(60, 62, 64, 66, 68, 128);
    private static final List<Integer> keyByteLenList = Arrays.asList(30, 31, 32, 33, 34, 64);

    public Sm2Utils() {
        this.cipherMode = CipherMode.C1C2C3;
    }

    public Sm2Utils(CipherMode cipherMode) {
        this.cipherMode = cipherMode;
    }

    public Sm2Utils(CipherMode cipherMode, String string) {
        this.cipherMode = cipherMode;
        this.randomKeyHex = string;
    }

    public String[] generateKeyPair() {
        II11iIiI iI11iIiI = new II11iIiI();
        i111IiI1 i111IiI12 = iI11iIiI.II11iIiI();
        return new String[]{ByteUtils.bytesToHex(i111IiI12.II11iIiI()), ByteUtils.bytesToHex(i111IiI12.I111ii1I())};
    }

    public String getPublicKey(String string) {
        II11iIiI iI11iIiI = new II11iIiI();
        byte[] byArray = iI11iIiI.II11iIiI(ByteUtils.hexToBytes(string));
        return ByteUtils.bytesToHex(byArray);
    }

    public String encryptFromText(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:encryptFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptFromText]invalid sourceText");
        }
        if (StringUtils.length(string) < 130 && !string.startsWith("04")) {
            string = "04" + string;
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.stringToBytes(string2);
        byte[] byArray3 = this.encryptFromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public String encryptFromHex(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:encryptFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptFromHex]invalid sourceHex");
        }
        if (string.length() < 130 && !string.startsWith("04")) {
            string = "04" + string;
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.encryptFromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public byte[] encryptFromData(byte[] byArray, byte[] byArray2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:encryptFromBytes]invalid pubKeyBytes");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new InvalidSourceDataException("[SM2:encryptFromBytes]invalid sourceBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI(this.cipherMode, this.randomKeyHex);
        return iI11iIiI.II11iIiI(byArray, byArray2);
    }

    public String decryptToText(String string, String string2) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:decryptToText]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(string2)) {
            throw new InvalidCryptoDataException("[SM2:decryptToText]invalid cipherHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.decryptToData(byArray, byArray2);
        return ByteUtils.bytesToString(byArray3);
    }

    public String decryptToHex(String string, String string2) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:decryptToHex]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(string2)) {
            throw new InvalidCryptoDataException("[SM2:decryptToHex]invalid cipherHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.decryptToData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public byte[] decryptToData(byte[] byArray, byte[] byArray2) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:decryptToData]invalid prvKeyBytes");
        }
        if (this.invalidCipherObj(byArray2)) {
            throw new InvalidCryptoDataException("[SM2:decryptToData]invalid cipherBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI(this.cipherMode, this.randomKeyHex);
        return iI11iIiI.i1iI111I(byArray, byArray2);
    }

    public String encryptASN1FromText(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:encryptASN1FromText]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptASN1FromText]invalid sourceText");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.stringToBytes(string2);
        byte[] byArray3 = this.encryptASN1FromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public String encryptASN1FromHex(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:encryptASN1FromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptASN1FromHex]invalid sourceText");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.encryptASN1FromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public byte[] encryptASN1FromData(byte[] byArray, byte[] byArray2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:encryptASN1FromData]invalid pubKeyBytes");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new InvalidSourceDataException("[SM2:encryptASN1FromData]invalid sourceBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI(CipherMode.C1C3C2, this.randomKeyHex);
        return iI11iIiI.I111ii1I(byArray, byArray2);
    }

    public String decryptASN1ToText(String string, String string2) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:decryptASN1ToText]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(string2)) {
            throw new InvalidCryptoDataException("[SM2:decryptASN1ToText]invalid cipherHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.decryptASN1ToData(byArray, byArray2);
        return ByteUtils.bytesToString(byArray3);
    }

    public String decryptASN1ToHex(String string, String string2) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:decryptASN1ToHex]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(string2)) {
            throw new InvalidCryptoDataException("[SM2:decryptASN1ToHex]invalid cipherHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.decryptASN1ToData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public byte[] decryptASN1ToData(byte[] byArray, byte[] byArray2) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:decryptASN1ToData]invalid prvKeyBytes");
        }
        if (this.invalidCipherObj(byArray2)) {
            throw new InvalidCryptoDataException("[SM2:decryptASN1ToData]invalid cipherBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI(CipherMode.C1C3C2, this.randomKeyHex);
        return iI11iIiI.iI1II1Ii(byArray, byArray2);
    }

    public String signFromText(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:signFromText]invalid prvKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromText]invalid sourceText");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.stringToBytes(string2);
        byte[] byArray3 = this.signFromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public String signFromHex(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:signFromHex]invalid prvKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromHex]invalid sourceText");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.signFromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public byte[] signFromData(byte[] byArray, byte[] byArray2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:signFromData]invalid prvKeyBytes");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new InvalidSourceDataException("[SM2:signFromData]invalid sourceBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI();
        return iI11iIiI.I1iIiI1I(byArray, byArray2);
    }

    public boolean verifySignFromText(String string, String string2, String string3) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:verifySignFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromText]invalid sourceText");
        }
        if (StringUtils.length(string3) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.stringToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        return this.verifySignFromData(byArray, byArray2, byArray3);
    }

    public boolean verifySignFromHex(String string, String string2, String string3) throws InvalidKeyException, InvalidSourceDataException, InvalidSignDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:verifySignFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid sourceText");
        }
        if (StringUtils.length(string3) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        return this.verifySignFromData(byArray, byArray2, byArray3);
    }

    public boolean verifySignFromData(byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:verifySignFromData]invalid pubKeyBytes");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromData]invalid sourceBytes");
        }
        if (byArray3 == null || byArray3.length != 64) {
            throw new InvalidSignDataException("[SM2:verifySignFromData]invalid signBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI();
        return iI11iIiI.I111ii1I(byArray, byArray2, byArray3);
    }

    public String signASN1FromText(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:signFromText]invalid prvKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromText]invalid sourceText");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.stringToBytes(string2);
        byte[] byArray3 = this.signASN1FromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public String signASN1FromHex(String string, String string2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:signFromHex]invalid prvKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromHex]invalid sourceText");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = this.signASN1FromData(byArray, byArray2);
        return ByteUtils.bytesToHex(byArray3);
    }

    public byte[] signASN1FromData(byte[] byArray, byte[] byArray2) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:signFromData]invalid prvKeyBytes");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new InvalidSourceDataException("[SM2:signFromData]invalid sourceBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI();
        return iI11iIiI.Iii11I11(byArray, byArray2);
    }

    public boolean verifySignASN1FromText(String string, String string2, String string3) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:verifySignFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromText]invalid sourceText");
        }
        if (StringUtils.length(string3) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.stringToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        return this.verifySignASN1FromData(byArray, byArray2, byArray3);
    }

    public boolean verifySignASN1FromHex(String string, String string2, String string3) throws InvalidKeyException, InvalidSourceDataException, InvalidSignDataException {
        if (this.invalidKey(string)) {
            throw new InvalidKeyException("[SM2:verifySignFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(string2) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid sourceText");
        }
        if (StringUtils.length(string3) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        return this.verifySignASN1FromData(byArray, byArray2, byArray3);
    }

    public boolean verifySignASN1FromData(byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(byArray)) {
            throw new InvalidKeyException("[SM2:verifySignFromData]invalid pubKeyBytes");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromData]invalid sourceBytes");
        }
        if (byArray3 == null || byArray3.length == 0) {
            throw new InvalidSignDataException("[SM2:verifySignFromData]invalid signBytes");
        }
        II11iIiI iI11iIiI = new II11iIiI();
        return iI11iIiI.i111IiI1(byArray, byArray2, byArray3);
    }

    private final boolean invalidKey(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            if (n == 130 && string.startsWith("04")) {
                return false;
            }
            return !keyHexLenList.contains(n);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 65 && byArray[0] == 4) {
                return false;
            }
            return !keyByteLenList.contains(byArray.length);
        }
        return true;
    }

    private final boolean invalidCipherObj(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            return n < 196 || n % 2 == 1;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return byArray.length < 98;
        }
        return true;
    }
}

